/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1String;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.test.ASN1UnitTest;
import cfca.sadk.org.bouncycastle.asn1.x500.DirectoryString;
import cfca.sadk.org.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import java.io.IOException;

public class NameOrPseudonymUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "NameOrPseudonym";
    }

    public void performTest() throws Exception {
        String pseudonym = "pseudonym";
        DirectoryString surname = new DirectoryString("surname");
        DERSequence givenName = new DERSequence(new DirectoryString("givenName"));
        NameOrPseudonym id = new NameOrPseudonym(pseudonym);
        this.checkConstruction(id, pseudonym, null, null);
        id = new NameOrPseudonym(surname, givenName);
        this.checkConstruction(id, null, surname, givenName);
        id = NameOrPseudonym.getInstance(null);
        if (id != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            NameOrPseudonym.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(NameOrPseudonym id, String pseudonym, DirectoryString surname, ASN1Sequence givenName) throws IOException {
        this.checkValues(id, pseudonym, surname, givenName);
        id = NameOrPseudonym.getInstance(id);
        this.checkValues(id, pseudonym, surname, givenName);
        ASN1InputStream aIn = new ASN1InputStream(id.toASN1Object().getEncoded());
        if (surname != null) {
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            id = NameOrPseudonym.getInstance(seq);
        } else {
            ASN1String s = (ASN1String)((Object)aIn.readObject());
            id = NameOrPseudonym.getInstance(s);
        }
        this.checkValues(id, pseudonym, surname, givenName);
    }

    private void checkValues(NameOrPseudonym id, String pseudonym, DirectoryString surname, ASN1Sequence givenName) {
        if (surname != null) {
            this.checkMandatoryField("surname", surname, id.getSurname());
            this.checkMandatoryField("givenName", givenName, new DERSequence(id.getGivenName()[0]));
        } else {
            this.checkOptionalField("pseudonym", new DirectoryString(pseudonym), id.getPseudonym());
        }
    }

    public static void main(String[] args) {
        NameOrPseudonymUnitTest.runTest(new NameOrPseudonymUnitTest());
    }
}

