/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Enumerated;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameBuilder;
import cfca.sadk.org.bouncycastle.asn1.x500.style.RFC4519Style;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLReason;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.ExtensionsGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralNames;
import cfca.sadk.org.bouncycastle.asn1.x509.KeyPurposeId;
import cfca.sadk.org.bouncycastle.asn1.x509.KeyUsage;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertificate;
import cfca.sadk.org.bouncycastle.cert.CertException;
import cfca.sadk.org.bouncycastle.cert.X509CRLEntryHolder;
import cfca.sadk.org.bouncycastle.cert.X509CRLHolder;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.X509v2CRLBuilder;
import cfca.sadk.org.bouncycastle.cert.X509v3CertificateBuilder;
import cfca.sadk.org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import cfca.sadk.org.bouncycastle.cert.bc.BcX509v1CertificateBuilder;
import cfca.sadk.org.bouncycastle.cert.bc.BcX509v3CertificateBuilder;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import cfca.sadk.org.bouncycastle.cert.test.PEMData;
import cfca.sadk.org.bouncycastle.cert.test.SHA1DigestCalculator;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.generators.DSAParametersGenerator;
import cfca.sadk.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.DSAParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import cfca.sadk.org.bouncycastle.operator.ContentSigner;
import cfca.sadk.org.bouncycastle.operator.ContentVerifierProvider;
import cfca.sadk.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cfca.sadk.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.bc.BcDSAContentSignerBuilder;
import cfca.sadk.org.bouncycastle.operator.bc.BcDSAContentVerifierProviderBuilder;
import cfca.sadk.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import cfca.sadk.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class BcCertTest
extends TestCase {
    DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
    DefaultDigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    byte[] cert1 = Base64.decode("MIIDXjCCAsegAwIBAgIBBzANBgkqhkiG9w0BAQQFADCBtzELMAkGA1UEBhMCQVUxETAPBgNVBAgTCFZpY3RvcmlhMRgwFgYDVQQHEw9Tb3V0aCBNZWxib3VybmUxGjAYBgNVBAoTEUNvbm5lY3QgNCBQdHkgTHRkMR4wHAYDVQQLExVDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxFTATBgNVBAMTDENvbm5lY3QgNCBDQTEoMCYGCSqGSIb3DQEJARYZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTAeFw0wMDA2MDIwNzU2MjFaFw0wMTA2MDIwNzU2MjFaMIG4MQswCQYDVQQGEwJBVTERMA8GA1UECBMIVmljdG9yaWExGDAWBgNVBAcTD1NvdXRoIE1lbGJvdXJuZTEaMBgGA1UEChMRQ29ubmVjdCA0IFB0eSBMdGQxFzAVBgNVBAsTDldlYnNlcnZlciBUZWFtMR0wGwYDVQQDExR3d3cyLmNvbm5lY3Q0LmNvbS5hdTEoMCYGCSqGSIb3DQEJARYZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEArvDxclKAhyv7Q/Wmr2reGw4XL9Cnh9e+6VgWy2AWNy/MVeXdlxzd7QAuc1eOWQkGQEiLPy5XQtTY+sBUJ3AORvd2fEVJIcjf29ey7bYua9J/vz5MG2KYo9/WCHIwqD9mmG9g0xLcfwq/s8ZJBswE7sb85VU+h94PTvsWOsWuKaECAwEAAaN3MHUwJAYDVR0RBB0wG4EZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTA6BglghkgBhvhCAQ0ELRYrbW9kX3NzbCBnZW5lcmF0ZWQgY3VzdG9tIHNlcnZlciBjZXJ0aWZpY2F0ZTARBglghkgBhvhCAQEEBAMCBkAwDQYJKoZIhvcNAQEEBQADgYEAotccfKpwSsIxM1Hae8DR7M/Rw8dg/RqOWx45HNVLiBS4/3N/TO195yeQKbfmzbAA2jbPVvIvGgTxPgO1MP4ZgvgRhasaa0qCJCkWvpM4yQf33vOiYQbpv4rTwzU8AmRlBG45WdjyNIigGV+oRc61aKCTnLq7zB8N3z1TF/bF5/8=");
    byte[] cert2 = Base64.decode("MIIDbDCCAtWgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBtzELMAkGA1UEBhMCQVUxETAPBgNVBAgTCFZpY3RvcmlhMRgwFgYDVQQHEw9Tb3V0aCBNZWxib3VybmUxGjAYBgNVBAoTEUNvbm5lY3QgNCBQdHkgTHRkMR4wHAYDVQQLExVDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxFTATBgNVBAMTDENvbm5lY3QgNCBDQTEoMCYGCSqGSIb3DQEJARYZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTAeFw0wMDA2MDIwNzU1MzNaFw0wMTA2MDIwNzU1MzNaMIG3MQswCQYDVQQGEwJBVTERMA8GA1UECBMIVmljdG9yaWExGDAWBgNVBAcTD1NvdXRoIE1lbGJvdXJuZTEaMBgGA1UEChMRQ29ubmVjdCA0IFB0eSBMdGQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhvcml0eTEVMBMGA1UEAxMMQ29ubmVjdCA0IENBMSgwJgYJKoZIhvcNAQkBFhl3ZWJtYXN0ZXJAY29ubmVjdDQuY29tLmF1MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDgs5ptNG6Qv1ZpCDuUNGmvrhjqMDPd3ri8JzZNRiiFlBA4e6/ReaO1U8ASewDeQMH6i9R6degFdQRLngbuJP0sxcEE+SksEWNvygfzLwV9J/q+TQDyJYK52utb++lS0b48A1KPLwEsyL6kOAgelburukwxowprKUIV7Knf1ajetQIDAQABo4GFMIGCMCQGA1UdEQQdMBuBGXdlYm1hc3RlckBjb25uZWN0NC5jb20uYXUwDwYDVR0TBAgwBgEB/wIBADA2BglghkgBhvhCAQ0EKRYnbW9kX3NzbCBnZW5lcmF0ZWQgY3VzdG9tIENBIGNlcnRpZmljYXRlMBEGCWCGSAGG+EIBAQQEAwICBDANBgkqhkiG9w0BAQQFAAOBgQCsGvfdghH8pPhlwm1r3pQkmsnLAVIBb01EhbXm2861iXZfWqGQjrGAaA0ZpXNk9oo110yxoqEoSJSzniZa7XtzsoTwNUpE0SLHvWf/SlKdFWlzXA+vOZbzEv4UmjeelekTm7lc01EEa5QRVzOxHFtQDhkaJ8VqOMajkQFma2r9iA==");
    byte[] cert3 = Base64.decode("MIIBWzCCAQYCARgwDQYJKoZIhvcNAQEEBQAwODELMAkGA1UEBhMCQVUxDDAKBgNVBAgTA1FMRDEbMBkGA1UEAxMSU1NMZWF5L3JzYSB0ZXN0IENBMB4XDTk1MDYxOTIzMzMxMloXDTk1MDcxNzIzMzMxMlowOjELMAkGA1UEBhMCQVUxDDAKBgNVBAgTA1FMRDEdMBsGA1UEAxMUU1NMZWF5L3JzYSB0ZXN0IGNlcnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAqtt6qS5GTxVxGZYWa0/4u+IwHf7p2LNZbcPBp9/OfIcYAXBQn8hO/Re1uwLKXdCjIoaGs4DLdG88rkzfyK5dPQIDAQABMAwGCCqGSIb3DQIFBQADQQAEWc7EcF8po2/ZO6kNCwK/ICH6DobgLekA5lSLr5EvuioZniZp5lFzAw4+YzPQ7XKJzl9HYIMxATFyqSiD9jsx");
    byte[] cert4 = Base64.decode("MIICjTCCAfigAwIBAgIEMaYgRzALBgkqhkiG9w0BAQQwRTELMAkGA1UEBhMCVVMxNjA0BgNVBAoTLU5hdGlvbmFsIEFlcm9uYXV0aWNzIGFuZCBTcGFjZSBBZG1pbmlzdHJhdGlvbjAmFxE5NjA1MjgxMzQ5MDUrMDgwMBcROTgwNTI4MTM0OTA1KzA4MDAwZzELMAkGA1UEBhMCVVMxNjA0BgNVBAoTLU5hdGlvbmFsIEFlcm9uYXV0aWNzIGFuZCBTcGFjZSBBZG1pbmlzdHJhdGlvbjEgMAkGA1UEBRMCMTYwEwYDVQQDEwxTdGV2ZSBTY2hvY2gwWDALBgkqhkiG9w0BAQEDSQAwRgJBALrAwyYdgxmzNP/ts0Uyf6BpmiJYktU/w4NG67ULaN4B5CnEz7k57s9o3YY3LecETgQ5iQHmkwlYDTL2fTgVfw0CAQOjgaswgagwZAYDVR0ZAQH/BFowWDBWMFQxCzAJBgNVBAYTAlVTMTYwNAYDVQQKEy1OYXRpb25hbCBBZXJvbmF1dGljcyBhbmQgU3BhY2UgQWRtaW5pc3RyYXRpb24xDTALBgNVBAMTBENSTDEwFwYDVR0BAQH/BA0wC4AJODMyOTcwODEwMBgGA1UdAgQRMA8ECTgzMjk3MDgyM4ACBSAwDQYDVR0KBAYwBAMCBkAwCwYJKoZIhvcNAQEEA4GBAH2y1VCEw/A4zaXzSYZJTTUi3uawbbFiS2yxHvgf28+8Js0OHXk1H1w2d6qOHH21X82tZXd/0JtG0g1T9usFFBDvYK8O0ebgz/P5ELJnBL2+atObEuJy1ZZ0pBDWINR3WkDNLCGiTkCKp0F5EWIrVDwh54NNevkCQRZita+z4IBO");
    byte[] cert5 = Base64.decode("MIICiTCCAfKgAwIBAgIEMeZfHzANBgkqhkiG9w0BAQQFADB9MQswCQYDVQQGEwJDYTEPMA0GA1UEBxMGTmVwZWFuMR4wHAYDVQQLExVObyBMaWFiaWxpdHkgQWNjZXB0ZWQxHzAdBgNVBAoTFkZvciBEZW1vIFB1cnBvc2VzIE9ubHkxHDAaBgNVBAMTE0VudHJ1c3QgRGVtbyBXZWIgQ0EwHhcNOTYwNzEyMTQyMDE1WhcNOTYxMDEyMTQyMDE1WjB0MSQwIgYJKoZIhvcNAQkBExVjb29rZUBpc3NsLmF0bC5ocC5jb20xCzAJBgNVBAYTAlVTMScwJQYDVQQLEx5IZXdsZXR0IFBhY2thcmQgQ29tcGFueSAoSVNTTCkxFjAUBgNVBAMTDVBhdWwgQS4gQ29va2UwXDANBgkqhkiG9w0BAQEFAANLADBIAkEA6ceSq9a9AU6g+zBwaL/yVmW1/9EE8s5you1mgjHnj0wAILuoB3L6rm6jmFRy7QZTG43IhVZdDua4e+5/n1ZslwIDAQABo2MwYTARBglghkgBhvhCAQEEBAMCB4AwTAYJYIZIAYb4QgENBD8WPVRoaXMgY2VydGlmaWNhdGUgaXMgb25seSBpbnRlbmRlZCBmb3IgZGVtb25zdHJhdGlvbiBwdXJwb3Nlcy4wDQYJKoZIhvcNAQEEBQADgYEAi8qcF3zfFqy1sV8NhjwLVwOKuSfhR/Z8mbIEUeSTlnH3QbYt3HWZQ+vXI8mvtZoBc2FzlexKeIkAZXCesqGbs6z6nCt16P6tmdfbZF3I3AWzLquPcOXjPf4HgstkyvVBn0ApjAFN418KF/Cx4qyHB4cjdvLrRjjQLnb2+ibo7QU=");
    byte[] cert6 = Base64.decode("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");
    byte[] cert7 = Base64.decode("MIIEXAYJKoZIhvcNAQcCoIIETTCCBEkCAQExCzAJBgUrDgMCGgUAMAsGCSqGSIb3DQEHAaCCAsMwggK/MIIB4AIBADCBpwYFKw4DAhswgZ0CQQEkJRHP+mN7d8miwTMN55CUSmo3TO8WGCxgY61TX5k+7NU4XPf1TULjw3GobwaJX13kquPhfVXk+gVy46n4Iw3hAhUBSe/QF4BUj+pJOF9ROBM4u+FEWA8CQQD4mSJbrABjTUWrlnAte8pS22Tq4/FPO7jHSqjijUHfXKTrHL1OEqV3SVWcFy5j/cqBgX/zm8Q12PFp/PjOhh+nMA4xDDAKBgNVBAMTA0lEMzAeFw05NzEwMDEwMDAwMDBaFw0zODAxMDEwMDAwMDBaMA4xDDAKBgNVBAMTA0lEMzCB8DCBpwYFKw4DAhswgZ0CQQEkJRHP+mN7d8miwTMN55CUSmo3TO8WGCxgY61TX5k+7NU4XPf1TULjw3GobwaJX13kquPhfVXk+gVy46n4Iw3hAhUBSe/QF4BUj+pJOF9ROBM4u+FEWA8CQQD4mSJbrABjTUWrlnAte8pS22Tq4/FPO7jHSqjijUHfXKTrHL1OEqV3SVWcFy5j/cqBgX/zm8Q12PFp/PjOhh+nA0QAAkEAkYkXLYMtGVGWj9OnzjPnsB9sefSRPrVegZJCZbpW+Iv0/1RP1u04pHG9vtRpIQLjzUiWvLMU9EKQTThceNMmWDCBpwYFKw4DAhswgZ0CQQEkJRHP+mN7d8miwTMN55CUSmo3TO8WGCxgY61TX5k+7NU4XPf1TULjw3GobwaJX13kquPhfVXk+gVy46n4Iw3hAhUBSe/QF4BUj+pJOF9ROBM4u+FEWA8CQQD4mSJbrABjTUWrlnAte8pS22Tq4/FPO7jHSqjijUHfXKTrHL1OEqV3SVWcFy5j/cqBgX/zm8Q12PFp/PjOhh+nAy8AMCwCFBY3dBSdeprGcqpr6wr3xbG+6WW+AhRMm/facKJNxkT3iKgJbp7R8Xd3QTGCAWEwggFdAgEBMBMwDjEMMAoGA1UEAxMDSUQzAgEAMAkGBSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0wMjA1MjQyMzEzMDdaMCMGCSqGSIb3DQEJBDEWBBS4WMsoJhf7CVbZYCFcjoTRzPkJxjCBpwYFKw4DAhswgZ0CQQEkJRHP+mN7d8miwTMN55CUSmo3TO8WGCxgY61TX5k+7NU4XPf1TULjw3GobwaJX13kquPhfVXk+gVy46n4Iw3hAhUBSe/QF4BUj+pJOF9ROBM4u+FEWA8CQQD4mSJbrABjTUWrlnAte8pS22Tq4/FPO7jHSqjijUHfXKTrHL1OEqV3SVWcFy5j/cqBgX/zm8Q12PFp/PjOhh+nBC8wLQIVALIDdt+MHwawrDrwsO1Z6sXBaaJsAhRaKssrpevmLkbygKPV07XiAKBG02Zvb2Jhcg==");
    byte[] crl1 = Base64.decode("MIICjTCCAfowDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5Fw05NTA1MDIwMjEyMjZaFw05NTA2MDEwMDAxNDlaMIIBaDAWAgUCQQAABBcNOTUwMjAxMTcyNDI2WjAWAgUCQQAACRcNOTUwMjEwMDIxNjM5WjAWAgUCQQAADxcNOTUwMjI0MDAxMjQ5WjAWAgUCQQAADBcNOTUwMjI1MDA0NjQ0WjAWAgUCQQAAGxcNOTUwMzEzMTg0MDQ5WjAWAgUCQQAAFhcNOTUwMzE1MTkxNjU0WjAWAgUCQQAAGhcNOTUwMzE1MTk0MDQxWjAWAgUCQQAAHxcNOTUwMzI0MTk0NDMzWjAWAgUCcgAABRcNOTUwMzI5MjAwNzExWjAWAgUCcgAAERcNOTUwMzMwMDIzNDI2WjAWAgUCQQAAIBcNOTUwNDA3MDExMzIxWjAWAgUCcgAAHhcNOTUwNDA4MDAwMjU5WjAWAgUCcgAAQRcNOTUwNDI4MTcxNzI0WjAWAgUCcgAAOBcNOTUwNDI4MTcyNzIxWjAWAgUCcgAATBcNOTUwNTAyMDIxMjI2WjANBgkqhkiG9w0BAQIFAAN+AHqOEJXSDejYy0UwxxrH/9+N2z5xu/if0J6qQmK92W0hW158wpJg+ovV3+wQwvIEPRL2rocL0tKfAsVq1IawSJzSNgxG0lrcla3MrJBnZ4GaZDu4FutZh72MR3GtJaAL3iTJHJD55kK2D/VoyY1djlsPuNh6AEgdVwFAyp0v");
    byte[] oldEcdsa = Base64.decode("MIICljCCAkCgAwIBAgIBATALBgcqhkjOPQQBBQAwgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKEx9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHEwlNZWxib3VybmUxETAPBgNVBAgTCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzAeFw0wMTEyMDcwMTAwMDRaFw0wMTEyMDcwMTAxNDRaMIGPMQswCQYDVQQGEwJBVTEoMCYGA1UEChMfVGhlIExlZ2lvbiBvZiB0aGUgQm91bmN5IENhc3RsZTESMBAGA1UEBxMJTWVsYm91cm5lMREwDwYDVQQIEwhWaWN0b3JpYTEvMC0GCSqGSIb3DQEJARYgZmVlZGJhY2stY3J5cHRvQGJvdW5jeWNhc3RsZS5vcmcwgeQwgb0GByqGSM49AgEwgbECAQEwKQYHKoZIzj0BAQIef///////////////f///////gAAAAAAAf///////MEAEHn///////////////3///////4AAAAAAAH///////AQeawFsO9zxiUHQ1lSSFHXKcanbL7J9HTd5YYXClCwKBB8CD/qWPNyogWzMM7hkK+35BcPTWFc9Pyf7vTs8uaqvAh5///////////////9///+eXpqfXZBx+9FSJoiQnQsDIgAEHwJbbcU7xholSP+w9nFHLebJUhqdLSU05lq/y9X+DHAwCwYHKoZIzj0EAQUAA0MAMEACHnz6t4UNoVROp74ma4XNDjjGcjaqiIWPZLK8Bdw3GQIeLZ4j3a6ividZl344UH+UPUE7xJxlYGuy7ejTsqRR");
    byte[] keyUsage = Base64.decode("MIIE7TCCBFagAwIBAgIEOAOR7jANBgkqhkiG9w0BAQQFADCByTELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MUgwRgYDVQQLFD93d3cuZW50cnVzdC5uZXQvQ2xpZW50X0NBX0luZm8vQ1BTIGluY29ycC4gYnkgcmVmLiBsaW1pdHMgbGlhYi4xJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENsaWVudCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTEwMTIxOTI0MzBaFw0xOTEwMTIxOTU0MzBaMIHJMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxSDBGBgNVBAsUP3d3dy5lbnRydXN0Lm5ldC9DbGllbnRfQ0FfSW5mby9DUFMgaW5jb3JwLiBieSByZWYuIGxpbWl0cyBsaWFiLjElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDIOpleMRffrCdvkHvkGf9FozTC28GoT/Bo6oT9n3V5z8GKUZSvx1cDR2SerYIbWtp/N3hHuzeYEpbOxhN979IMMFGpOZ5V+Pux5zDeg7K6PvHViTs7hbqqdCz+PzFur5GVbgbUB01LLFZHGARS2g4Qk79jkJvh34zmAqTmT173iwIBA6OCAeAwggHcMBEGCWCGSAGG+EIBAQQEAwIABzCCASIGA1UdHwSCARkwggEVMIHkoIHhoIHepIHbMIHYMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxSDBGBgNVBAsUP3d3dy5lbnRydXN0Lm5ldC9DbGllbnRfQ0FfSW5mby9DUFMgaW5jb3JwLiBieSByZWYuIGxpbWl0cyBsaWFiLjElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCygKqAohiZodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9DbGllbnQxLmNybDArBgNVHRAEJDAigA8xOTk5MTAxMjE5MjQzMFqBDzIwMTkxMDEyMTkyNDMwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUxPucKXuXzUyW/O5bs8qZdIuV6kwwHQYDVR0OBBYEFMT7nCl7l81MlvzuW7PKmXSLlepMMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEEBQADgYEAP66K8ddmAwWePvrqHEa7pFuPeJoSSJn59DXeDDYHAmsQOokUgZwxpnyyQbJq5wcBoUv5nyU7lsqZwz6hURzzwy5E97BnRqqS5TvaHBkUODDV4qIxJS7x7EU47fgGWANzYrAQMY9Av2TgXD7FTx/aEkP/TOYGJqibGapEPHayXOw=");
    byte[] nameCert = Base64.decode("MIIEFjCCA3+gAwIBAgIEdS8BozANBgkqhkiG9w0BAQUFADBKMQswCQYDVQQGEwJERTERMA8GA1UEChQIREFURVYgZUcxKDAMBgcCggYBCgcUEwExMBgGA1UEAxQRQ0EgREFURVYgRDAzIDE6UE4wIhgPMjAwMTA1MTAxMDIyNDhaGA8yMDA0MDUwOTEwMjI0OFowgYQxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIFAZCYXllcm4xEjAQBgNVBAcUCU7IdXJuYmVyZzERMA8GA1UEChQIREFURVYgZUcxHTAbBgNVBAUTFDAwMDAwMDAwMDA4OTU3NDM2MDAxMR4wHAYDVQQDFBVEaWV0bWFyIFNlbmdlbmxlaXRuZXIwgaEwDQYJKoZIhvcNAQEBBQADgY8AMIGLAoGBAJLI/LJLKaHoMk8fBECW/od8u5erZi6jI8UgC0a/LZyQUO/R20vWJs6GrClQtXB+AtfiBSnyZOSYzOdfDI8yEKPEv8qSuUPpOHpsuNCFdLZF1vavVYGEEWs2+y+uuPmg8q1oPRyRmUZ+x9HrDvCXJraaDfTEd9olmB/ZAuC/PqpjAgUAwAAAAaOCAcYwggHCMAwGA1UdEwEB/wQCMAAwDwYDVR0PAQH/BAUDAwdAADAxBgNVHSAEKjAoMCYGBSskCAEBMB0wGwYIKwYBBQUHAgEWD3d3dy56cy5kYXRldi5kZTApBgNVHREEIjAggR5kaWV0bWFyLnNlbmdlbmxlaXRuZXJAZGF0ZXYuZGUwgYQGA1UdIwR9MHuhc6RxMG8xCzAJBgNVBAYTAkRFMT0wOwYDVQQKFDRSZWd1bGllcnVuZ3NiZWjIb3JkZSBmyHVyIFRlbGVrb21tdW5pa2F0aW9uIHVuZCBQb3N0MSEwDAYHAoIGAQoHFBMBMTARBgNVBAMUCjVSLUNBIDE6UE6CBACm8LkwDgYHAoIGAQoMAAQDAQEAMEcGA1UdHwRAMD4wPKAUoBKGEHd3dy5jcmwuZGF0ZXYuZGWiJKQiMCAxCzAJBgNVBAYTAkRFMREwDwYDVQQKFAhEQVRFViBlRzAWBgUrJAgDBAQNMAsTA0VVUgIBBQIBATAdBgNVHQ4EFgQUfv6xFP0xk7027folhy+ziZvBJiwwLAYIKwYBBQUHAQEEIDAeMBwGCCsGAQUFBzABhhB3d3cuZGlyLmRhdGV2LmRlMA0GCSqGSIb3DQEBBQUAA4GBAEOVX6uQxbgtKzdgbTi6YLffMftFr2mmNwch7qzpM5gxcynzgVkgpnQcDNlm5AIbS6pO8jTCLfCd5TZ5biQksBErqmesIl3QD+VqtB+RNghxectZ3VEsnCUtcE7tJ8O14qwCb3TxS9dvIUFiVi4DjbxX46TdcTbTaK8/qr6AIf+l");
    byte[] probSelfSignedCert = Base64.decode("MIICxTCCAi6gAwIBAgIQAQAAAAAAAAAAAAAAAAAAATANBgkqhkiG9w0BAQUFADBFMScwJQYDVQQKEx4gRElSRUNUSU9OIEdFTkVSQUxFIERFUyBJTVBPVFMxGjAYBgNVBAMTESBBQyBNSU5FRkkgQiBURVNUMB4XDTA0MDUwNzEyMDAwMFoXDTE0MDUwNzEyMDAwMFowRTEnMCUGA1UEChMeIERJUkVDVElPTiBHRU5FUkFMRSBERVMgSU1QT1RTMRowGAYDVQQDExEgQUMgTUlORUZJIEIgVEVTVDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAveoCUOAukZdcFCs2qJk76vSqEX0ZFzHqQ6faBPZWjwkgUNwZ6m6mqWvvyq1cuxhoDvpfC6NXILETawYc6MNwwxsOtVVIjuXlcF17NMejljJafbPximEtDQ4LcQeSp4K7FyFlIAMLyt3BQ77emGzU5fjFTvHSUNb3jblx0sV28c0CAwEAAaOBtTCBsjAfBgNVHSMEGDAWgBSEJ4bLbvEQY8cYMAFKPFD1/fFXlzAdBgNVHQ4EFgQUhCeGy27xEGPHGDABSjxQ9f3xV5cwDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIBAQQEAwIBBjA8BgNVHR8ENTAzMDGgL6AthitodHRwOi8vYWRvbmlzLnBrNy5jZXJ0cGx1cy5uZXQvZGdpLXRlc3QuY3JsMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAmToHJWjd3+4zknfsP09H6uMbolHNGG0zTS2lrLKpzcmkQfjhQpT9LUTBvfs1jdjo9fGmQLvOG+Sm51Rbjglb8bcikVI5gLbclOlvqLkm77otjl4U4Z2/Y0vP14Aov3Sn3k+17EfReYUZI4liuB95ncobC4e8ZM++LjQcIM0s+Vs=");
    byte[] gost34102001base = Base64.decode("MIIB1DCCAYECEEjpVKXP6Wn1yVz3VeeDQa8wCgYGKoUDAgIDBQAwbTEfMB0GA1UEAwwWR29zdFIzNDEwLTIwMDEgZXhhbXBsZTESMBAGA1UECgwJQ3J5cHRvUHJvMQswCQYDVQQGEwJSVTEpMCcGCSqGSIb3DQEJARYaR29zdFIzNDEwLTIwMDFAZXhhbXBsZS5jb20wHhcNMDUwMjAzMTUxNjQ2WhcNMTUwMjAzMTUxNjQ2WjBtMR8wHQYDVQQDDBZHb3N0UjM0MTAtMjAwMSBleGFtcGxlMRIwEAYDVQQKDAlDcnlwdG9Qcm8xCzAJBgNVBAYTAlJVMSkwJwYJKoZIhvcNAQkBFhpHb3N0UjM0MTAtMjAwMUBleGFtcGxlLmNvbTBjMBwGBiqFAwICEzASBgcqhQMCAiQABgcqhQMCAh4BA0MABECElWh1YAIaQHUIzROMMYks/eUFA3pDXPRtKw/nTzJ+V4/rzBa5lYgD0Jp8ha4P5I3qprt+VsfLsN8PZrzK6hpgMAoGBiqFAwICAwUAA0EAHw5dw/aw/OiNvHyOE65kvyo4Hp0sfz3csM6UUkp10VO247ofNJK3tsLbHOLjUaqzefrlGb11WpHYrvWFg+FcLA==");
    private final byte[] emptyDNCert = Base64.decode("MIICfTCCAeagAwIBAgIBajANBgkqhkiG9w0BAQQFADB8MQswCQYDVQQGEwJVUzEMMAoGA1UEChMDQ0RXMQkwBwYDVQQLEwAxCTAHBgNVBAcTADEJMAcGA1UECBMAMRowGAYDVQQDExFUZW1wbGFyIFRlc3QgMTAyNDEiMCAGCSqGSIb3DQEJARYTdGVtcGxhcnRlc3RAY2R3LmNvbTAeFw0wNjA1MjIwNTAwMDBaFw0xMDA1MjIwNTAwMDBaMHwxCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNDRFcxCTAHBgNVBAsTADEJMAcGA1UEBxMAMQkwBwYDVQQIEwAxGjAYBgNVBAMTEVRlbXBsYXIgVGVzdCAxMDI0MSIwIAYJKoZIhvcNAQkBFhN0ZW1wbGFydGVzdEBjZHcuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDH3aJpJBfM+A3d84j5YcU6zEQaQ76u5xO9NSBmHjZykKS2kCcUqPpvVOPDA5WgV22dtKPh+lYViUp7wyCVwAKibq8HIbihHceFqMKzjwC639rMoDJ7bi/yzQWz1Zg+075a4FGPlUKn7Yfu89wKkjdWwDpRPXc/agqBnrx5pJTXzQIDAQABow8wDTALBgNVHQ8EBAMCALEwDQYJKoZIhvcNAQEEBQADgYEARRsRsjse3i2/KClFVd6YLZ+7K1BE0WxFyY2bbytkwQJSxvv3vLSuweFUbhNxutb68wl/yW4GLy4b1QdyswNxrNDXTuu5ILKhRDDuWeocz83aG2KGtr3JlFyr3biWGEyn5WUOE6tbONoQDJ0oPYgI6CAcEHdUp0lioOCt6UOw7Cs=");
    private AsymmetricKeyParameter dudPublicKey = new AsymmetricKeyParameter(true){

        public String getAlgorithm() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return null;
        }
    };

    public String getName() {
        return "CertTest";
    }

    public void checkCertificate(int id, byte[] bytes) {
        try {
            X509CertificateHolder certHldr = new X509CertificateHolder(bytes);
            SubjectPublicKeyInfo k = certHldr.getSubjectPublicKeyInfo();
        }
        catch (Exception e) {
            BcCertTest.fail((String)e.toString());
        }
    }

    public void checkKeyUsage(int id, byte[] bytes) throws IOException {
        X509CertificateHolder certHld = new X509CertificateHolder(bytes);
        if ((DERBitString.getInstance(certHld.getExtension(Extension.keyUsage).getParsedValue()).getBytes()[0] & 1) != 0) {
            BcCertTest.fail((String)"error generating cert - key usage wrong.");
        }
    }

    public void checkSelfSignedCertificate(int id, byte[] bytes) throws OperatorCreationException, IOException, CertException {
        X509CertificateHolder certHolder = new X509CertificateHolder(bytes);
        BcCertTest.assertTrue((boolean)certHolder.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(certHolder)));
    }

    public void checkCreation1() throws Exception {
        List<String> l;
        RSAKeyParameters pubKey = new RSAKeyParameters(false, new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeyParameters privKey = new RSAPrivateCrtKeyParameters(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
        X500NameBuilder builder = new X500NameBuilder(RFC4519Style.INSTANCE);
        builder.addRDN(RFC4519Style.c, "AU");
        builder.addRDN(RFC4519Style.o, "The Legion of the Bouncy Castle");
        builder.addRDN(RFC4519Style.l, "Melbourne");
        builder.addRDN(RFC4519Style.st, "Victoria");
        builder.addRDN(PKCSObjectIdentifiers.pkcs_9_at_emailAddress, "feedback-crypto@bouncycastle.org");
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA256WithRSAEncryption");
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlg, this.digAlgFinder.find(sigAlg)).build(privKey);
        X509v3CertificateBuilder certGen = new BcX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), (AsymmetricKeyParameter)pubKey);
        X509CertificateHolder certH = certGen.build(sigGen);
        BcCertTest.assertTrue((boolean)certH.isValidOn(new Date()));
        ContentVerifierProvider contentVerifierProvider = new BcRSAContentVerifierProviderBuilder(new DefaultDigestAlgorithmIdentifierFinder()).build(pubKey);
        BcCertTest.assertTrue((boolean)certH.isSignatureValid(contentVerifierProvider));
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certH);
        Set<String> dummySet = cert.getNonCriticalExtensionOIDs();
        if (dummySet != null) {
            BcCertTest.fail((String)"non-critical oid set should be null");
        }
        if ((dummySet = cert.getCriticalExtensionOIDs()) != null) {
            BcCertTest.fail((String)"critical oid set should be null");
        }
        sigGen = new BcRSAContentSignerBuilder(this.sigAlgFinder.find("MD5WithRSA"), this.digAlgFinder.find(this.sigAlgFinder.find("MD5withRSA"))).build(privKey);
        certGen = new BcX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), (AsymmetricKeyParameter)pubKey).addExtension(new ASN1ObjectIdentifier("2.5.29.15"), true, new KeyUsage(1)).addExtension(new ASN1ObjectIdentifier("2.5.29.37"), true, new DERSequence(KeyPurposeId.anyExtendedKeyUsage)).addExtension(new ASN1ObjectIdentifier("2.5.29.17"), true, new GeneralNames(new GeneralName(1, "test@test.test")));
        X509CertificateHolder certHolder = certGen.build(sigGen);
        BcCertTest.assertTrue((boolean)certHolder.isValidOn(new Date()));
        contentVerifierProvider = new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey);
        if (!certHolder.isSignatureValid(contentVerifierProvider)) {
            BcCertTest.fail((String)"signature test failed");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(certHolder.getEncoded());
        CertificateFactory certFact = CertificateFactory.getInstance("X.509");
        cert = (X509Certificate)certFact.generateCertificate(bIn);
        if (!cert.getKeyUsage()[7]) {
            BcCertTest.fail((String)"error generating cert - key usage wrong.");
        }
        if (!(l = cert.getExtendedKeyUsage()).get(0).equals(KeyPurposeId.anyExtendedKeyUsage.getId())) {
            BcCertTest.fail((String)"failed extended key usage test");
        }
        Collection<List<?>> c = cert.getSubjectAlternativeNames();
        Iterator<List<?>> it = c.iterator();
        while (it.hasNext()) {
            List<?> gn = it.next();
            if (gn.get(1).equals("test@test.test")) continue;
            BcCertTest.fail((String)"failed subject alternative names test");
        }
        sigGen = new BcRSAContentSignerBuilder(this.sigAlgFinder.find("MD5WithRSA"), this.digAlgFinder.find(this.sigAlgFinder.find("MD5withRSA"))).build(privKey);
        BcX509v1CertificateBuilder certGen1 = new BcX509v1CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), pubKey);
        cert = new JcaX509CertificateConverter().getCertificate(certGen1.build(sigGen));
        BcCertTest.assertTrue((boolean)certHolder.isValidOn(new Date()));
        contentVerifierProvider = new BcRSAContentVerifierProviderBuilder(new DefaultDigestAlgorithmIdentifierFinder()).build(pubKey);
        BcCertTest.assertTrue((boolean)certHolder.isSignatureValid(contentVerifierProvider));
        bIn = new ByteArrayInputStream(cert.getEncoded());
        certFact = CertificateFactory.getInstance("X.509");
        cert = (X509Certificate)certFact.generateCertificate(bIn);
        if (!((Object)cert.getIssuerDN()).equals(cert.getSubjectDN())) {
            BcCertTest.fail((String)"name comparison fails");
        }
        RSAKeyParameters lwPubKey = new RSAKeyParameters(false, new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeyParameters lwPrivKey = new RSAPrivateCrtKeyParameters(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
        builder = new X500NameBuilder(RFC4519Style.INSTANCE);
        builder.addRDN(RFC4519Style.c, "AU");
        builder.addRDN(RFC4519Style.o, "The Legion of the Bouncy Castle");
        builder.addRDN(RFC4519Style.l, "Melbourne");
        builder.addRDN(RFC4519Style.st, "Victoria");
        builder.addRDN(PKCSObjectIdentifiers.pkcs_9_at_emailAddress, "feedback-crypto@bouncycastle.org");
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WithRSAEncryption");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(lwPrivKey);
        SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(lwPubKey);
        certGen = new X509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), pubInfo);
        certHolder = certGen.build(sigGen);
        BcCertTest.assertTrue((boolean)certHolder.isValidOn(new Date()));
        contentVerifierProvider = new BcRSAContentVerifierProviderBuilder(new DefaultDigestAlgorithmIdentifierFinder()).build(lwPubKey);
        BcCertTest.assertTrue((boolean)certHolder.isSignatureValid(contentVerifierProvider));
        if (!certHolder.isSignatureValid(contentVerifierProvider)) {
            BcCertTest.fail((String)"lw sig verification failed");
        }
    }

    public void checkCreation2() throws Exception {
        DSAKeyPairGenerator kpg = new DSAKeyPairGenerator();
        BigInteger r = new BigInteger("68076202252361894315274692543577577550894681403");
        BigInteger s = new BigInteger("1089214853334067536215539335472893651470583479365");
        DSAParametersGenerator pGen = new DSAParametersGenerator();
        pGen.init(512, 80, new SecureRandom());
        DSAParameters params = pGen.generateParameters();
        DSAKeyGenerationParameters genParam = new DSAKeyGenerationParameters(new SecureRandom(), params);
        kpg.init(genParam);
        AsymmetricCipherKeyPair pair = kpg.generateKeyPair();
        AsymmetricKeyParameter privKey = pair.getPrivate();
        AsymmetricKeyParameter pubKey = pair.getPublic();
        X500NameBuilder builder = this.createStdBuilder();
        AlgorithmIdentifier sigAlgId = this.sigAlgFinder.find("SHA1withDSA");
        AlgorithmIdentifier digAlgId = this.digAlgFinder.find(sigAlgId);
        ContentSigner sigGen = new BcDSAContentSignerBuilder(sigAlgId, digAlgId).build(privKey);
        BcX509v3CertificateBuilder certGen = new BcX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), pubKey);
        X509CertificateHolder cert = certGen.build(sigGen);
        BcCertTest.assertTrue((boolean)cert.isValidOn(new Date()));
        BcCertTest.assertTrue((boolean)cert.isSignatureValid(new BcDSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey)));
        sigAlgId = this.sigAlgFinder.find("SHA1withDSA");
        digAlgId = this.digAlgFinder.find(sigAlgId);
        sigGen = new BcDSAContentSignerBuilder(sigAlgId, digAlgId).build(privKey);
        BcX509v1CertificateBuilder certGen1 = new BcX509v1CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), pubKey);
        cert = certGen1.build(sigGen);
        BcCertTest.assertTrue((boolean)cert.isValidOn(new Date()));
        BcCertTest.assertTrue((boolean)cert.isSignatureValid(new BcDSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey)));
        ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getEncoded());
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate x509cert = (X509Certificate)fact.generateCertificate(bIn);
    }

    private X500NameBuilder createStdBuilder() {
        X500NameBuilder builder = new X500NameBuilder(RFC4519Style.INSTANCE);
        builder.addRDN(RFC4519Style.c, "AU");
        builder.addRDN(RFC4519Style.o, "The Legion of the Bouncy Castle");
        builder.addRDN(RFC4519Style.l, "Melbourne");
        builder.addRDN(RFC4519Style.st, "Victoria");
        builder.addRDN(PKCSObjectIdentifiers.pkcs_9_at_emailAddress, "feedback-crypto@bouncycastle.org");
        return builder;
    }

    private void checkCRL(int id, byte[] bytes) {
        String dump = "";
        try {
            X509CRLHolder crlHolder = new X509CRLHolder(bytes);
        }
        catch (Exception e) {
            BcCertTest.fail((String)(dump + System.getProperty("line.separator") + this.getName() + ": " + id + " failed - exception " + e.toString()));
        }
    }

    public void checkCRLCreation1() throws Exception {
        Extension ext;
        Extension authExt;
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters genParam = new RSAKeyGenerationParameters(BigInteger.valueOf(4097L), new SecureRandom(), 1024, 25);
        kpg.init(genParam);
        AsymmetricCipherKeyPair pair = kpg.generateKeyPair();
        Date now = new Date();
        X509v2CRLBuilder crlGen = new X509v2CRLBuilder(new X500Name("CN=Test CA"), now);
        BcX509ExtensionUtils extFact = new BcX509ExtensionUtils(new SHA1DigestCalculator());
        crlGen.setNextUpdate(new Date(now.getTime() + 100000L));
        crlGen.addCRLEntry(BigInteger.ONE, now, 9);
        crlGen.addExtension(Extension.authorityKeyIdentifier, false, extFact.createAuthorityKeyIdentifier(pair.getPublic()));
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA256withRSAEncryption");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        X509CRLHolder crl = crlGen.build(new BcRSAContentSignerBuilder(sigAlg, digAlg).build(pair.getPrivate()));
        if (!crl.getIssuer().equals(new X500Name("CN=Test CA"))) {
            BcCertTest.fail((String)"failed CRL issuer test");
        }
        if ((authExt = crl.getExtension(Extension.authorityKeyIdentifier)) == null) {
            BcCertTest.fail((String)"failed to find CRL extension");
        }
        AuthorityKeyIdentifier authId = AuthorityKeyIdentifier.getInstance(authExt.getParsedValue());
        X509CRLEntryHolder entry = crl.getRevokedCertificate(BigInteger.ONE);
        if (entry == null) {
            BcCertTest.fail((String)"failed to find CRL entry");
        }
        if (!entry.getSerialNumber().equals(BigInteger.ONE)) {
            BcCertTest.fail((String)"CRL cert serial number does not match");
        }
        if (!entry.hasExtensions()) {
            BcCertTest.fail((String)"CRL entry extension not found");
        }
        if ((ext = entry.getExtension(Extension.reasonCode)) != null) {
            ASN1Enumerated reasonCode = ASN1Enumerated.getInstance(ext.getParsedValue());
            if (reasonCode.getValue().intValue() != 9) {
                BcCertTest.fail((String)"CRL entry reasonCode wrong");
            }
        } else {
            BcCertTest.fail((String)"CRL entry reasonCode not found");
        }
    }

    public void checkCRLCreation2() throws Exception {
        Extension ext;
        Extension authExt;
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters genParam = new RSAKeyGenerationParameters(BigInteger.valueOf(4097L), new SecureRandom(), 1024, 25);
        kpg.init(genParam);
        AsymmetricCipherKeyPair pair = kpg.generateKeyPair();
        Date now = new Date();
        X509v2CRLBuilder crlGen = new X509v2CRLBuilder(new X500Name("CN=Test CA"), now);
        crlGen.setNextUpdate(new Date(now.getTime() + 100000L));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        CRLReason crlReason = CRLReason.lookup(9);
        extGen.addExtension(Extension.reasonCode, false, crlReason);
        BcX509ExtensionUtils extFact = new BcX509ExtensionUtils(new SHA1DigestCalculator());
        crlGen.addCRLEntry(BigInteger.ONE, now, extGen.generate());
        crlGen.addExtension(Extension.authorityKeyIdentifier, false, extFact.createAuthorityKeyIdentifier(pair.getPublic()));
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA256withRSAEncryption");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        X509CRLHolder crlHolder = crlGen.build(new BcRSAContentSignerBuilder(sigAlg, digAlg).build(pair.getPrivate()));
        if (!crlHolder.getIssuer().equals(new X500Name("CN=Test CA"))) {
            BcCertTest.fail((String)"failed CRL issuer test");
        }
        if ((authExt = crlHolder.getExtension(Extension.authorityKeyIdentifier)) == null) {
            BcCertTest.fail((String)"failed to find CRL extension");
        }
        AuthorityKeyIdentifier authId = AuthorityKeyIdentifier.getInstance(authExt.getParsedValue());
        X509CRLEntryHolder entry = crlHolder.getRevokedCertificate(BigInteger.ONE);
        if (entry == null) {
            BcCertTest.fail((String)"failed to find CRL entry");
        }
        if (!entry.getSerialNumber().equals(BigInteger.ONE)) {
            BcCertTest.fail((String)"CRL cert serial number does not match");
        }
        if (!entry.hasExtensions()) {
            BcCertTest.fail((String)"CRL entry extension not found");
        }
        if ((ext = entry.getExtension(Extension.reasonCode)) != null) {
            ASN1Enumerated reasonCode = ASN1Enumerated.getInstance(ext.getParsedValue());
            if (reasonCode.getValue().intValue() != 9) {
                BcCertTest.fail((String)"CRL entry reasonCode wrong");
            }
        } else {
            BcCertTest.fail((String)"CRL entry reasonCode not found");
        }
    }

    public void checkCRLCreation3() throws Exception {
        Collection<? extends CRL> col;
        CertificateFactory cFact;
        X509CRL readCrl;
        Extension ext;
        Extension authExt;
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters genParam = new RSAKeyGenerationParameters(BigInteger.valueOf(4097L), new SecureRandom(), 1024, 25);
        kpg.init(genParam);
        AsymmetricCipherKeyPair pair = kpg.generateKeyPair();
        Date now = new Date();
        X509v2CRLBuilder crlGen = new X509v2CRLBuilder(new X500Name("CN=Test CA"), now);
        crlGen.setNextUpdate(new Date(now.getTime() + 100000L));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        CRLReason crlReason = CRLReason.lookup(9);
        extGen.addExtension(Extension.reasonCode, false, crlReason);
        BcX509ExtensionUtils extFact = new BcX509ExtensionUtils(new SHA1DigestCalculator());
        Extensions entryExtensions = extGen.generate();
        crlGen.addCRLEntry(BigInteger.ONE, now, entryExtensions);
        crlGen.addExtension(Extension.authorityKeyIdentifier, false, extFact.createAuthorityKeyIdentifier(pair.getPublic()));
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("SHA256withRSAEncryption");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        X509CRLHolder crlHolder = crlGen.build(new BcRSAContentSignerBuilder(sigAlg, digAlg).build(pair.getPrivate()));
        if (!crlHolder.getIssuer().equals(new X500Name("CN=Test CA"))) {
            BcCertTest.fail((String)"failed CRL issuer test");
        }
        if ((authExt = crlHolder.getExtension(Extension.authorityKeyIdentifier)) == null) {
            BcCertTest.fail((String)"failed to find CRL extension");
        }
        AuthorityKeyIdentifier authId = AuthorityKeyIdentifier.getInstance(authExt.getParsedValue());
        X509CRLEntryHolder entry = crlHolder.getRevokedCertificate(BigInteger.ONE);
        if (entry == null) {
            BcCertTest.fail((String)"failed to find CRL entry");
        }
        if (!entry.getSerialNumber().equals(BigInteger.ONE)) {
            BcCertTest.fail((String)"CRL cert serial number does not match");
        }
        if (!entry.hasExtensions()) {
            BcCertTest.fail((String)"CRL entry extension not found");
        }
        if ((ext = entry.getExtension(Extension.reasonCode)) != null) {
            ASN1Enumerated reasonCode = ASN1Enumerated.getInstance(ext.getParsedValue());
            if (reasonCode.getValue().intValue() != 9) {
                BcCertTest.fail((String)"CRL entry reasonCode wrong");
            }
        } else {
            BcCertTest.fail((String)"CRL entry reasonCode not found");
        }
        now = new Date();
        crlGen = new X509v2CRLBuilder(new X500Name("CN=Test CA"), now);
        crlGen.setNextUpdate(new Date(now.getTime() + 100000L));
        crlGen.addCRL(crlHolder);
        crlGen.addCRLEntry(BigInteger.valueOf(2L), now, entryExtensions);
        crlGen.addExtension(Extension.authorityKeyIdentifier, false, extFact.createAuthorityKeyIdentifier(pair.getPublic()));
        crlHolder = crlGen.build(new BcRSAContentSignerBuilder(sigAlg, digAlg).build(pair.getPrivate()));
        int count = 0;
        boolean oneFound = false;
        boolean twoFound = false;
        Iterator it = crlHolder.getRevokedCertificates().iterator();
        while (it.hasNext()) {
            X509CRLEntryHolder crlEnt = (X509CRLEntryHolder)it.next();
            if (crlEnt.getSerialNumber().intValue() == 1) {
                oneFound = true;
                Extension extn = crlEnt.getExtension(Extension.reasonCode);
                if (extn != null) {
                    ASN1Enumerated reasonCode = ASN1Enumerated.getInstance(extn.getParsedValue());
                    if (reasonCode.getValue().intValue() != 9) {
                        BcCertTest.fail((String)"CRL entry reasonCode wrong on recheck");
                    }
                } else {
                    BcCertTest.fail((String)"CRL entry reasonCode not found on recheck");
                }
            } else if (crlEnt.getSerialNumber().intValue() == 2) {
                twoFound = true;
            }
            ++count;
        }
        if (count != 2) {
            BcCertTest.fail((String)("wrong number of CRLs found, got: " + count));
        }
        if (!oneFound || !twoFound) {
            BcCertTest.fail((String)"wrong CRLs found in copied list");
        }
        if ((readCrl = (X509CRL)(cFact = CertificateFactory.getInstance("X.509")).generateCRL(new ByteArrayInputStream(crlHolder.getEncoded()))) == null) {
            BcCertTest.fail((String)"crl not returned!");
        }
        if ((col = cFact.generateCRLs(new ByteArrayInputStream(crlHolder.getEncoded()))).size() != 1) {
            BcCertTest.fail((String)"wrong number of CRLs found in collection");
        }
    }

    public void checkCreation5() throws Exception {
        RSAKeyParameters pubKey = new RSAKeyParameters(false, new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeyParameters privKey = new RSAPrivateCrtKeyParameters(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
        SecureRandom rand = new SecureRandom();
        X500NameBuilder builder = this.createStdBuilder();
        AlgorithmIdentifier sigAlg = this.sigAlgFinder.find("MD5WithRSA");
        AlgorithmIdentifier digAlg = this.digAlgFinder.find(sigAlg);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlg, digAlg).build(privKey);
        ASN1ObjectIdentifier extOid = new ASN1ObjectIdentifier("2.5.29.37");
        X509v3CertificateBuilder certGen = new BcX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), (AsymmetricKeyParameter)pubKey).addExtension(new ASN1ObjectIdentifier("2.5.29.15"), true, new KeyUsage(1)).addExtension(extOid, true, new DERSequence(KeyPurposeId.anyExtendedKeyUsage)).addExtension(new ASN1ObjectIdentifier("2.5.29.17"), true, new GeneralNames(new GeneralName(1, "test@test.test")));
        X509CertificateHolder baseCert = certGen.build(sigGen);
        certGen = new BcX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), (AsymmetricKeyParameter)pubKey).copyAndAddExtension(new ASN1ObjectIdentifier("2.5.29.15"), true, baseCert).copyAndAddExtension(extOid, false, baseCert);
        X509CertificateHolder cert = certGen.build(sigGen);
        BcCertTest.assertTrue((boolean)cert.isValidOn(new Date()));
        BcCertTest.assertTrue((boolean)cert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey)));
        if (!baseCert.getExtension(new ASN1ObjectIdentifier("2.5.29.15")).equals(cert.getExtension(new ASN1ObjectIdentifier("2.5.29.15")))) {
            BcCertTest.fail((String)"2.5.29.15 differs");
        }
        BcCertTest.assertTrue((boolean)baseCert.getExtension(extOid).getExtnId().equals(cert.getExtension(extOid).getExtnId()));
        BcCertTest.assertFalse((baseCert.getExtension(extOid).isCritical() == cert.getExtension(extOid).isCritical() ? 1 : 0) != 0);
        if (!baseCert.getExtension(extOid).getParsedValue().equals(cert.getExtension(extOid).getParsedValue())) {
            BcCertTest.fail((String)"2.5.29.37 differs");
        }
        try {
            certGen.copyAndAddExtension(new ASN1ObjectIdentifier("2.5.99.99"), true, baseCert);
            BcCertTest.fail((String)"exception not thrown on dud extension copy");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void testForgedSignature() throws Exception {
        String cert = "MIIBsDCCAVoCAQYwDQYJKoZIhvcNAQEFBQAwYzELMAkGA1UEBhMCQVUxEzARBgNVBAgTClF1ZWVuc2xhbmQxGjAYBgNVBAoTEUNyeXB0U29mdCBQdHkgTHRkMSMwIQYDVQQDExpTZXJ2ZXIgdGVzdCBjZXJ0ICg1MTIgYml0KTAeFw0wNjA5MTEyMzU4NTVaFw0wNjEwMTEyMzU4NTVaMGMxCzAJBgNVBAYTAkFVMRMwEQYDVQQIEwpRdWVlbnNsYW5kMRowGAYDVQQKExFDcnlwdFNvZnQgUHR5IEx0ZDEjMCEGA1UEAxMaU2VydmVyIHRlc3QgY2VydCAoNTEyIGJpdCkwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAn7PDhCeV/xIxUg8V70YRxK2A5jZbD92A12GN4PxyRQk0/lVmRUNMaJdq/qigpd9feP/u12S4PwTLb/8q/v657QIDAQABMA0GCSqGSIb3DQEBBQUAA0EAbynCRIlUQgaqyNgUDF6P14yRKUtX8akOP2TwStaSiVf/akYqfLFm3UGka5XbPj4rifrZ0/sOoZEEBvHQe20sRA==";
        X509CertificateHolder hldr = new X509CertificateHolder(Base64.decode(cert));
        BcCertTest.assertFalse((boolean)hldr.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(hldr)));
    }

    private void pemTest() throws Exception {
        Collection<Object> col;
        CRL crl;
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate cert = BcCertTest.readPEMCert(cf, PEMData.CERTIFICATE_1);
        if (cert == null) {
            BcCertTest.fail((String)"PEM cert not read");
        }
        if ((cert = BcCertTest.readPEMCert(cf, "-----BEGIN CERTIFICATE-----" + PEMData.CERTIFICATE_2)) == null) {
            BcCertTest.fail((String)"PEM cert with extraneous header not read");
        }
        if ((crl = cf.generateCRL(new ByteArrayInputStream(PEMData.CRL_1.getBytes("US-ASCII")))) == null) {
            BcCertTest.fail((String)"PEM crl not read");
        }
        if ((col = cf.generateCertificates(new ByteArrayInputStream(PEMData.CERTIFICATE_2.getBytes("US-ASCII")))).size() != 1 || !col.contains(cert)) {
            BcCertTest.fail((String)"PEM cert collection not right");
        }
        if ((col = cf.generateCRLs(new ByteArrayInputStream(PEMData.CRL_2.getBytes("US-ASCII")))).size() != 1 || !col.contains(crl)) {
            BcCertTest.fail((String)"PEM crl collection not right");
        }
    }

    private static X509Certificate readPEMCert(CertificateFactory cf, String pemData) throws CertificateException, UnsupportedEncodingException {
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(pemData.getBytes("US-ASCII")));
    }

    private void createPSSCert(String algorithm) throws Exception {
        AsymmetricCipherKeyPair pair = this.generateLongFixedKeys();
        AsymmetricKeyParameter privKey = pair.getPrivate();
        AsymmetricKeyParameter pubKey = pair.getPublic();
        X500NameBuilder builder = this.createStdBuilder();
        BcX509ExtensionUtils extFact = new BcX509ExtensionUtils(new SHA1DigestCalculator());
        AlgorithmIdentifier sigAlgId = this.sigAlgFinder.find(algorithm);
        AlgorithmIdentifier digAlgId = this.digAlgFinder.find(sigAlgId);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(privKey);
        BcX509v3CertificateBuilder certGen = new BcX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), builder.build(), pubKey);
        certGen.addExtension(new ASN1ObjectIdentifier("2.5.29.15"), true, new KeyUsage(1));
        certGen.addExtension(new ASN1ObjectIdentifier("2.5.29.37"), true, new DERSequence(KeyPurposeId.anyExtendedKeyUsage));
        certGen.addExtension(new ASN1ObjectIdentifier("2.5.29.17"), true, new GeneralNames(new GeneralName(1, "test@test.test")));
        certGen.addExtension(Extension.authorityKeyIdentifier, true, extFact.createAuthorityKeyIdentifier(pubKey));
        X509CertificateHolder baseCert = certGen.build(sigGen);
        BcCertTest.assertTrue((boolean)baseCert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(this.digAlgFinder).build(pubKey)));
    }

    private AsymmetricCipherKeyPair generateLongFixedKeys() {
        RSAKeyParameters pubKeySpec = new RSAKeyParameters(false, new BigInteger("a56e4a0e701017589a5187dc7ea841d156f2ec0e36ad52a44dfeb1e61f7ad991d8c51056ffedb162b4c0f283a12a88a394dff526ab7291cbb307ceabfce0b1dfd5cd9508096d5b2b8b6df5d671ef6377c0921cb23c270a70e2598e6ff89d19f105acc2d3f0cb35f29280e1386b6f64c4ef22e1e1f20d0ce8cffb2249bd9a2137", 16), new BigInteger("010001", 16));
        RSAPrivateCrtKeyParameters privKeySpec = new RSAPrivateCrtKeyParameters(new BigInteger("a56e4a0e701017589a5187dc7ea841d156f2ec0e36ad52a44dfeb1e61f7ad991d8c51056ffedb162b4c0f283a12a88a394dff526ab7291cbb307ceabfce0b1dfd5cd9508096d5b2b8b6df5d671ef6377c0921cb23c270a70e2598e6ff89d19f105acc2d3f0cb35f29280e1386b6f64c4ef22e1e1f20d0ce8cffb2249bd9a2137", 16), new BigInteger("010001", 16), new BigInteger("33a5042a90b27d4f5451ca9bbbd0b44771a101af884340aef9885f2a4bbe92e894a724ac3c568c8f97853ad07c0266c8c6a3ca0929f1e8f11231884429fc4d9ae55fee896a10ce707c3ed7e734e44727a39574501a532683109c2abacaba283c31b4bd2f53c3ee37e352cee34f9e503bd80c0622ad79c6dcee883547c6a3b325", 16), new BigInteger("e7e8942720a877517273a356053ea2a1bc0c94aa72d55c6e86296b2dfc967948c0a72cbccca7eacb35706e09a1df55a1535bd9b3cc34160b3b6dcd3eda8e6443", 16), new BigInteger("b69dca1cf7d4d7ec81e75b90fcca874abcde123fd2700180aa90479b6e48de8d67ed24f9f19d85ba275874f542cd20dc723e6963364a1f9425452b269a6799fd", 16), new BigInteger("28fa13938655be1f8a159cbaca5a72ea190c30089e19cd274a556f36c4f6e19f554b34c077790427bbdd8dd3ede2448328f385d81b30e8e43b2fffa027861979", 16), new BigInteger("1a8b38f398fa712049898d7fb79ee0a77668791299cdfa09efc0e507acb21ed74301ef5bfd48be455eaeb6e1678255827580a8e4e8e14151d1510a82a3f2e729", 16), new BigInteger("27156aba4126d24a81f3a528cbfb27f56886f840a9f6e86e17a44b94fe9319584b8e22fdde1e5a2e3bd8aa5ba8d8584194eb2190acf832b847f13a3d24a79f4d", 16));
        return new AsymmetricCipherKeyPair(pubKeySpec, privKeySpec);
    }

    public void testNullDerNullCert() throws Exception {
        AsymmetricCipherKeyPair pair = this.generateLongFixedKeys();
        AsymmetricKeyParameter pubKey = pair.getPublic();
        AsymmetricKeyParameter privKey = pair.getPrivate();
        DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
        DefaultDigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier sigAlgId = sigAlgFinder.find("MD5withRSA");
        AlgorithmIdentifier digAlgId = digAlgFinder.find(sigAlgId);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(privKey);
        BcX509v3CertificateBuilder certGen = new BcX509v3CertificateBuilder(new X500Name("CN=Test"), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name("CN=Test"), pubKey);
        X509CertificateHolder cert = certGen.build(sigGen);
        Certificate struct = Certificate.getInstance(cert.getEncoded());
        TBSCertificate tbsCertificate = struct.getTBSCertificate();
        AlgorithmIdentifier sig = struct.getSignatureAlgorithm();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(tbsCertificate);
        v.add(new AlgorithmIdentifier(sig.getAlgorithm()));
        v.add(struct.getSignature());
        String dump = "";
        ByteArrayInputStream bIn = new ByteArrayInputStream(new DERSequence(v).getEncoded());
        cert = new X509CertificateHolder(new DERSequence(v).getEncoded());
        BcCertTest.assertTrue((boolean)cert.isSignatureValid(new BcRSAContentVerifierProviderBuilder(digAlgFinder).build(pubKey)));
    }

    public void testCertificates() throws Exception {
        this.checkCertificate(1, this.cert1);
        this.checkCertificate(2, this.cert2);
        this.checkCertificate(3, this.cert3);
        this.checkCertificate(4, this.cert4);
        this.checkCertificate(5, this.cert5);
        this.checkKeyUsage(8, this.keyUsage);
        this.checkSelfSignedCertificate(11, this.probSelfSignedCert);
        this.checkCRL(1, this.crl1);
        this.checkCreation1();
        this.checkCreation2();
        this.checkCreation5();
        this.createPSSCert("SHA1withRSAandMGF1");
        this.createPSSCert("SHA224withRSAandMGF1");
        this.createPSSCert("SHA256withRSAandMGF1");
        this.createPSSCert("SHA384withRSAandMGF1");
        this.checkCRLCreation1();
        this.checkCRLCreation2();
        this.checkCRLCreation3();
        this.pemTest();
        this.checkCertificate(18, this.emptyDNCert);
    }
}

