/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class BlockCipherMonteCarloTest
extends SimpleTest {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int id, int iterations, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.iterations = iterations;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Monte Carlo Test " + this.id;
    }

    public void performTest() throws Exception {
        int len1;
        int i;
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        System.arraycopy(this.input, 0, out, 0, out.length);
        for (i = 0; i != this.iterations; ++i) {
            len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
        }
        if (!this.areEqual(out, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        cipher.init(false, this.param);
        for (i = 0; i != this.iterations; ++i) {
            len1 = cipher.processBytes(out, 0, out.length, out, 0);
            cipher.doFinal(out, len1);
        }
        if (!this.areEqual(this.input, out)) {
            this.fail("failed reversal");
        }
    }
}

