/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.Commitment;
import cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import cfca.sadk.org.bouncycastle.crypto.commitments.GeneralHashCommitter;
import cfca.sadk.org.bouncycastle.crypto.commitments.HashCommitter;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;

public class HashCommitmentTest
extends SimpleTest {
    public String getName() {
        return "HashCommitmentTest";
    }

    public void performBasicTest() throws Exception {
        block7: {
            Commitment c;
            HashCommitter committer;
            block6: {
                byte[] data = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
                committer = new HashCommitter(new SHA256Digest(), new SecureRandom());
                committer = new HashCommitter(new SHA256Digest(), new SecureRandom());
                c = committer.commit(data);
                if (!committer.isRevealed(c, data)) {
                    this.fail("commitment failed to validate");
                }
                if ((committer = new HashCommitter(new SHA1Digest(), new SecureRandom())).isRevealed(c, data)) {
                    this.fail("commitment validated!!");
                }
                try {
                    committer.isRevealed(c, new byte[data.length + 1]);
                }
                catch (Exception e) {
                    if (e.getMessage().equals("Message and witness secret lengths do not match.")) break block6;
                    this.fail("exception thrown but wrong message");
                }
            }
            try {
                c = committer.commit(new byte[33]);
            }
            catch (DataLengthException e) {
                if (e.getMessage().equals("Message to be committed to too large for digest.")) break block7;
                this.fail("exception thrown but wrong message");
            }
        }
    }

    public void performGeneralTest() throws Exception {
        block8: {
            Commitment c;
            GeneralHashCommitter committer;
            block7: {
                byte[] data = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
                committer = new GeneralHashCommitter(new SHA256Digest(), new SecureRandom());
                committer = new GeneralHashCommitter(new SHA256Digest(), new SecureRandom());
                c = committer.commit(data);
                if (!committer.isRevealed(c, data)) {
                    this.fail("general commitment failed to validate");
                }
                if ((committer = new GeneralHashCommitter(new SHA1Digest(), new SecureRandom())).isRevealed(c, data)) {
                    this.fail("general commitment validated!!");
                }
                c = committer.commit(data);
                byte[] s = c.getSecret();
                byte[] newS = Arrays.copyOfRange(s, 0, s.length - 1);
                byte[] newData = new byte[data.length + 1];
                newData[0] = s[s.length - 1];
                System.arraycopy(data, 0, newData, 1, data.length);
                c = new Commitment(newS, c.getCommitment());
                if (committer.isRevealed(c, newData)) {
                    this.fail("general commitment validated!!");
                }
                try {
                    committer.isRevealed(c, new byte[data.length + 1]);
                }
                catch (Exception e) {
                    if (e.getMessage().equals("Message and witness secret lengths do not match.")) break block7;
                    this.fail("exception thrown but wrong message");
                }
            }
            try {
                c = committer.commit(new byte[33]);
            }
            catch (DataLengthException e) {
                if (e.getMessage().equals("Message to be committed to too large for digest.")) break block8;
                this.fail("exception thrown but wrong message");
            }
        }
    }

    public void performTest() throws Exception {
        this.performBasicTest();
        this.performGeneralTest();
    }

    public static void main(String[] args) {
        HashCommitmentTest.runTest(new HashCommitmentTest());
    }
}

