/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.engines.DESEngine;
import cfca.sadk.org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import cfca.sadk.org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class ISO9797Alg3MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("7CA110454A1A6E570131D9619DC1376E");
    static byte[] input1 = "Hello World !!!!".getBytes();
    static byte[] output1 = Hex.decode("F09B856213BAB83B");

    public void performTest() {
        KeyParameter key = new KeyParameter(keyBytes);
        DESEngine cipher = new DESEngine();
        ISO9797Alg3Mac mac = new ISO9797Alg3Mac(cipher);
        mac.init(key);
        mac.update(input1, 0, input1.length);
        byte[] out = new byte[8];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(out)));
        }
        mac.reset();
        mac.init(key);
        for (int i = 0; i != input1.length / 2; ++i) {
            mac.update(input1[i]);
        }
        mac.update(input1, input1.length / 2, input1.length - input1.length / 2);
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Reset failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(out)));
        }
        this.testMacWithIv();
    }

    private void testMacWithIv() {
        byte[] inputData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] key = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
        byte[] zeroIv = new byte[8];
        byte[] nonZeroIv = new byte[]{5, 6, 7, 8, 1, 2, 3, 4};
        KeyParameter simpleParameter = new KeyParameter(key);
        ParametersWithIV zeroIvParameter = new ParametersWithIV(new KeyParameter(key), zeroIv);
        ISO9797Alg3Mac mac1 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding());
        mac1.init(simpleParameter);
        mac1.update(inputData, 0, inputData.length);
        byte[] output1 = new byte[mac1.getMacSize()];
        mac1.doFinal(output1, 0);
        ISO9797Alg3Mac mac2 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding());
        mac2.init(zeroIvParameter);
        mac2.update(inputData, 0, inputData.length);
        byte[] output2 = new byte[mac2.getMacSize()];
        mac2.doFinal(output2, 0);
        if (!Arrays.areEqual(output1, output2)) {
            this.fail("zero IV test failed");
        }
        ParametersWithIV nonZeroIvParameter = new ParametersWithIV(new KeyParameter(key), nonZeroIv);
        mac2 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding());
        mac2.init(nonZeroIvParameter);
        mac2.update(inputData, 0, inputData.length);
        output2 = new byte[mac2.getMacSize()];
        mac2.doFinal(output2, 0);
        if (Arrays.areEqual(output1, output2)) {
            this.fail("non-zero IV test failed");
        }
    }

    public String getName() {
        return "ISO9797Alg3Mac";
    }

    public static void main(String[] args) {
        ISO9797Alg3MacTest.runTest(new ISO9797Alg3MacTest());
    }
}

