/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import cfca.sadk.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.kems.RSAKeyEncapsulation;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "RSAKeyEncapsulation";
    }

    public void performTest() throws Exception {
        RSAKeyPairGenerator rsaGen = new RSAKeyPairGenerator();
        rsaGen.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 1024, 5));
        AsymmetricCipherKeyPair keys = rsaGen.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        byte[] out = new byte[128];
        RSAKeyEncapsulation kem = new RSAKeyEncapsulation(kdf, rnd);
        kem.init(keys.getPublic());
        KeyParameter key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        KeyParameter key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed test");
        }
    }

    public static void main(String[] args) {
        RSAKeyEncapsulationTest.runTest(new RSAKeyEncapsulationTest());
    }
}

