/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.generators.SCrypt;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class SCryptTest
extends SimpleTest {
    public String getName() {
        return "SCrypt";
    }

    public void performTest() throws Exception {
        this.testParameters();
        this.testVectors();
    }

    public void testParameters() {
        this.checkOK("Minimal values", new byte[0], new byte[0], 2, 1, 1, 1);
        this.checkIllegal("Cost parameter must be > 1", new byte[0], new byte[0], 1, 1, 1, 1);
        this.checkOK("Cost parameter 65536 OK for r == 1", new byte[0], new byte[0], 65536, 1, 1, 1);
        this.checkIllegal("Cost parameter must <= 65536 for r == 1", new byte[0], new byte[0], 65537, 1, 1, 1);
        this.checkIllegal("Block size must be >= 1", new byte[0], new byte[0], 2, 0, 2, 1);
        this.checkIllegal("Parallelisation parameter must be >= 1", new byte[0], new byte[0], 2, 1, 0, 1);
        this.checkIllegal("Parallelisation parameter must be < 65535 for r = 4", new byte[0], new byte[0], 2, 32, 65536, 1);
        this.checkIllegal("Len parameter must be > 1", new byte[0], new byte[0], 2, 1, 1, 0);
    }

    private void checkOK(String msg, byte[] pass, byte[] salt, int N, int r, int p, int len) {
        try {
            SCrypt.generate(pass, salt, N, r, p, len);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.fail(msg);
        }
    }

    private void checkIllegal(String msg, byte[] pass, byte[] salt, int N, int r, int p, int len) {
        try {
            SCrypt.generate(pass, salt, N, r, p, len);
            this.fail(msg);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testVectors() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("SCryptTestVectors.txt")));
        int count = 0;
        String line = br.readLine();
        while (line != null) {
            byte[] result;
            ++count;
            String header = line;
            StringBuffer data = new StringBuffer();
            while (!SCryptTest.isEndData(line = br.readLine())) {
                for (int i = 0; i != line.length(); ++i) {
                    if (line.charAt(i) == ' ') continue;
                    data.append(line.charAt(i));
                }
            }
            int start = header.indexOf(40) + 1;
            int limit = header.lastIndexOf(41);
            String argStr = header.substring(start, limit);
            String[] args = Strings.split(argStr, ',');
            byte[] P = SCryptTest.extractQuotedString(args[0]);
            byte[] S = SCryptTest.extractQuotedString(args[1]);
            int N = SCryptTest.extractInteger(args[2]);
            int r = SCryptTest.extractInteger(args[3]);
            int p = SCryptTest.extractInteger(args[4]);
            int dkLen = SCryptTest.extractInteger(args[5]);
            byte[] expected = Hex.decode(data.toString());
            if (N > 16384 || this.areEqual(expected, result = SCrypt.generate(P, S, N, r, p, dkLen))) continue;
            this.fail("Result does not match expected value in test case " + count);
        }
        br.close();
    }

    private static boolean isEndData(String line) {
        return line == null || line.startsWith("scrypt");
    }

    private static byte[] extractQuotedString(String arg) {
        arg = arg.trim();
        arg = arg.substring(1, arg.length() - 1);
        return Strings.toByteArray(arg);
    }

    private static int extractInteger(String arg) {
        return Integer.parseInt(arg.trim());
    }

    public static void main(String[] args) {
        SCryptTest.runTest(new SCryptTest());
    }
}

