/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls.test;

import cfca.sadk.org.bouncycastle.crypto.tls.TlsClientProtocol;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsServerProtocol;
import cfca.sadk.org.bouncycastle.crypto.tls.test.MockTlsClient;
import cfca.sadk.org.bouncycastle.crypto.tls.test.MockTlsServer;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.io.Streams;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.SecureRandom;
import junit.framework.TestCase;

public class TlsProtocolTest
extends TestCase {
    public void testClientServer() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        PipedInputStream clientRead = new PipedInputStream();
        PipedInputStream serverRead = new PipedInputStream();
        PipedOutputStream clientWrite = new PipedOutputStream(serverRead);
        PipedOutputStream serverWrite = new PipedOutputStream(clientRead);
        TlsClientProtocol clientProtocol = new TlsClientProtocol(clientRead, clientWrite, secureRandom);
        TlsServerProtocol serverProtocol = new TlsServerProtocol(serverRead, serverWrite, secureRandom);
        ServerThread serverThread = new ServerThread(serverProtocol);
        serverThread.start();
        MockTlsClient client = new MockTlsClient(null);
        clientProtocol.connect(client);
        int length = 1000;
        byte[] data = new byte[length];
        secureRandom.nextBytes(data);
        OutputStream output = clientProtocol.getOutputStream();
        output.write(data);
        byte[] echo = new byte[data.length];
        int count = Streams.readFully(clientProtocol.getInputStream(), echo);
        TlsProtocolTest.assertEquals((int)count, (int)data.length);
        TlsProtocolTest.assertTrue((boolean)Arrays.areEqual(data, echo));
        output.close();
        serverThread.join();
    }

    static class ServerThread
    extends Thread {
        private final TlsServerProtocol serverProtocol;

        ServerThread(TlsServerProtocol serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        public void run() {
            try {
                MockTlsServer server = new MockTlsServer();
                this.serverProtocol.accept(server);
                Streams.pipeAll(this.serverProtocol.getInputStream(), this.serverProtocol.getOutputStream());
                this.serverProtocol.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

