/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls.test;

import cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestCase;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestConfig;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TlsTestSuite
extends TestSuite {
    public static Test suite() {
        TlsTestSuite testSuite = new TlsTestSuite();
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv10);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv11);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv12);
        return testSuite;
    }

    private static void addVersionTests(TestSuite testSuite, ProtocolVersion version) {
        String prefix = version.toString().replaceAll("[ \\.]", "") + "_";
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(version);
        testSuite.addTest((Test)new TlsTestCase(c, prefix + "GoodDefault"));
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 3;
        c.expectServerFatalAlert((short)51);
        testSuite.addTest((Test)new TlsTestCase(c, prefix + "BadCertificateVerify"));
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 2;
        c.expectServerFatalAlert((short)42);
        testSuite.addTest((Test)new TlsTestCase(c, prefix + "BadClientCertificate"));
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 0;
        c.serverCertReq = 2;
        c.expectServerFatalAlert((short)40);
        testSuite.addTest((Test)new TlsTestCase(c, prefix + "BadMandatoryCertReqDeclined"));
        c = TlsTestSuite.createTlsTestConfig(version);
        c.serverCertReq = 0;
        testSuite.addTest((Test)new TlsTestCase(c, prefix + "GoodNoCertReq"));
        c = TlsTestSuite.createTlsTestConfig(version);
        c.clientAuth = 0;
        testSuite.addTest((Test)new TlsTestCase(c, prefix + "GoodOptionalCertReqDeclined"));
    }

    private static TlsTestConfig createTlsTestConfig(ProtocolVersion version) {
        TlsTestConfig c = new TlsTestConfig();
        c.clientMinimumVersion = ProtocolVersion.TLSv10;
        c.clientOfferVersion = ProtocolVersion.TLSv12;
        c.serverMaximumVersion = version;
        c.serverMinimumVersion = ProtocolVersion.TLSv10;
        return c;
    }

    static abstract class C
    extends TlsTestConfig {
        C() {
        }
    }
}

