/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider;

import cfca.sadk.org.bouncycastle.jce.provider.AnnotatedException;
import cfca.sadk.org.bouncycastle.util.StoreException;
import cfca.sadk.org.bouncycastle.x509.ExtendedPKIXParameters;
import cfca.sadk.org.bouncycastle.x509.X509CRLStoreSelector;
import cfca.sadk.org.bouncycastle.x509.X509Store;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXCRLUtil {
    public Set findCRLs(X509CRLStoreSelector crlselect, ExtendedPKIXParameters paramsPKIX, Date currentDate) throws AnnotatedException {
        HashSet initialSet = new HashSet();
        try {
            initialSet.addAll(this.findCRLs(crlselect, paramsPKIX.getAdditionalStores()));
            initialSet.addAll(this.findCRLs(crlselect, paramsPKIX.getStores()));
            initialSet.addAll(this.findCRLs(crlselect, paramsPKIX.getCertStores()));
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", e);
        }
        HashSet<X509CRL> finalSet = new HashSet<X509CRL>();
        Date validityDate = currentDate;
        if (paramsPKIX.getDate() != null) {
            validityDate = paramsPKIX.getDate();
        }
        Iterator it = initialSet.iterator();
        while (it.hasNext()) {
            X509CRL crl = (X509CRL)it.next();
            if (!crl.getNextUpdate().after(validityDate)) continue;
            X509Certificate cert = crlselect.getCertificateChecking();
            if (cert != null) {
                if (!crl.getThisUpdate().before(cert.getNotAfter())) continue;
                finalSet.add(crl);
                continue;
            }
            finalSet.add(crl);
        }
        return finalSet;
    }

    public Set findCRLs(X509CRLStoreSelector crlselect, PKIXParameters paramsPKIX) throws AnnotatedException {
        HashSet completeSet = new HashSet();
        try {
            completeSet.addAll(this.findCRLs(crlselect, paramsPKIX.getCertStores()));
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", e);
        }
        return completeSet;
    }

    private final Collection findCRLs(X509CRLStoreSelector crlSelect, List crlStores) throws AnnotatedException {
        HashSet<? extends CRL> crls = new HashSet<CRL>();
        Iterator iter = crlStores.iterator();
        AnnotatedException lastException = null;
        boolean foundValidStore = false;
        while (iter.hasNext()) {
            Object store;
            Object obj = iter.next();
            if (obj instanceof X509Store) {
                store = (X509Store)obj;
                try {
                    crls.addAll(((X509Store)store).getMatches(crlSelect));
                    foundValidStore = true;
                }
                catch (StoreException e) {
                    lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
                }
                continue;
            }
            store = (CertStore)obj;
            try {
                crls.addAll(((CertStore)store).getCRLs(crlSelect));
                foundValidStore = true;
            }
            catch (CertStoreException e) {
                lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
            }
        }
        if (!foundValidStore && lastException != null) {
            throw lastException;
        }
        return crls;
    }
}

