/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider.test;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DESedeTest
extends SimpleTest {
    static String[] cipherTests1 = new String[]{"112", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "128", "2f4bc6b30c893fa549d82c560d61cf3eb088aed020603de249d82c560d61cf3e529e95ecd8e05394", "168", "50ddb583a25c21e6c9233f8e57a86d40bb034af421c03096c9233f8e57a86d402fce91e8eb639f89", "192", "50ddb583a25c21e6c9233f8e57a86d40bb034af421c03096c9233f8e57a86d402fce91e8eb639f89"};
    static byte[] input1 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");

    public String getName() {
        return "DESEDE";
    }

    private boolean equalArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equalArray(byte[] a, byte[] b, int length) {
        if (a.length < length) {
            return false;
        }
        if (b.length < length) {
            return false;
        }
        for (int i = 0; i != length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private void wrapTest(String alg, int id, byte[] kek, byte[] iv, byte[] in, byte[] out) {
        try {
            Cipher wrapper = Cipher.getInstance(alg + "Wrap", "BC");
            wrapper.init(3, (Key)new SecretKeySpec(kek, alg), new IvParameterSpec(iv));
            try {
                byte[] cText = wrapper.wrap(new SecretKeySpec(in, alg));
                if (!this.equalArray(cText, out)) {
                    this.fail("failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText)));
                }
            }
            catch (Exception e) {
                this.fail("failed wrap test exception " + e.toString());
            }
            wrapper.init(4, new SecretKeySpec(kek, alg));
            try {
                Key pText = wrapper.unwrap(out, alg, 3);
                if (!this.equalArray(pText.getEncoded(), in)) {
                    this.fail("failed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText.getEncoded())));
                }
            }
            catch (Exception e) {
                this.fail("failed unwrap test exception " + e.toString());
            }
        }
        catch (Exception ex) {
            this.fail("failed exception " + ex.toString());
        }
    }

    public void test(String alg, int strength, byte[] input, byte[] output) {
        SecretKey key = null;
        Cipher in = null;
        Cipher out = null;
        FixedSecureRandom rand = new FixedSecureRandom();
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(alg, "BC");
            keyGen.init(strength, (SecureRandom)rand);
            key = keyGen.generateKey();
            in = Cipher.getInstance(alg + "/ECB/PKCS7Padding", "BC");
            out = Cipher.getInstance(alg + "/ECB/PKCS7Padding", "BC");
            out.init(1, (Key)key, (SecureRandom)rand);
        }
        catch (Exception e) {
            this.fail(alg + " failed initialisation - " + e.toString());
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail(alg + " failed initialisation - " + e.toString());
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            for (int i = 0; i != input.length / 2; ++i) {
                cOut.write(input[i]);
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail(alg + " failed encryption - " + e.toString());
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.equalArray(bytes, output)) {
            this.fail(alg + " failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            for (int i = 0; i != input.length / 2; ++i) {
                bytes[i] = (byte)dIn.read();
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail(alg + " failed encryption - " + e.toString());
        }
        if (!this.equalArray(bytes, input)) {
            this.fail(alg + " failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(alg, "BC");
            DESedeKeySpec keySpec = (DESedeKeySpec)keyFactory.getKeySpec(key, DESedeKeySpec.class);
            if (!this.equalArray(key.getEncoded(), keySpec.getKey(), 16)) {
                this.fail(alg + " KeySpec does not match key.");
            }
        }
        catch (Exception e) {
            this.fail(alg + " failed keyspec - " + e.toString());
        }
    }

    public void performTest() {
        int i;
        for (i = 0; i != cipherTests1.length; i += 2) {
            this.test("DESEDE", Integer.parseInt(cipherTests1[i]), input1, Hex.decode(cipherTests1[i + 1]));
        }
        for (i = 0; i != cipherTests1.length; i += 2) {
            this.test("TDEA", Integer.parseInt(cipherTests1[i]), input1, Hex.decode(cipherTests1[i + 1]));
        }
        byte[] kek1 = Hex.decode("255e0d1c07b646dfb3134cc843ba8aa71f025b7c0838251f");
        byte[] iv1 = Hex.decode("5dd4cbfc96f5453b");
        byte[] in1 = Hex.decode("2923bf85e06dd6ae529149f1f1bae9eab3a7da3d860d3e98");
        byte[] out1 = Hex.decode("690107618ef092b3b48ca1796b234ae9fa33ebb4159604037db5d6a84eb3aac2768c632775a467d4");
        this.wrapTest("DESEDE", 1, kek1, iv1, in1, out1);
        this.wrapTest("TDEA", 1, kek1, iv1, in1, out1);
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        DESedeTest.runTest(new DESedeTest());
    }

    private class FixedSecureRandom
    extends SecureRandom {
        byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};

        private FixedSecureRandom() {
        }

        public void nextBytes(byte[] bytes) {
            int offset = 0;
            while (offset + this.seed.length < bytes.length) {
                System.arraycopy(this.seed, 0, bytes, offset, this.seed.length);
                offset += this.seed.length;
            }
            System.arraycopy(this.seed, 0, bytes, offset, bytes.length - offset);
        }
    }
}

