/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.jce.netscape.NetscapeCertRequest;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import cfca.sadk.org.bouncycastle.util.test.SimpleTestResult;
import cfca.sadk.org.bouncycastle.util.test.Test;
import cfca.sadk.org.bouncycastle.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;

public class NetscapeCertRequestTest
implements Test {
    static final String test1 = "MIIBRzCBsTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmwdh+LJXQ8AtXczo4EIGfXjpmDwsoIRpPaXEx1CBHhpon/Dpo/o5Vw2WoWNICXj5lmqhftIpCPO9qKxx85x6k/fuyTPH8P02hkmscAYsgqOgb/1yRCNXFryuFOATqxw1tsuye5Q3lTU9JCLUUilQ6BV8n3fm2egtPPUaJEuCvcsCAwEAARYNZml4ZWQtZm9yLW5vdzANBgkqhkiG9w0BAQQFAAOBgQAImbJD6xHbJtXl6kOTbCFoMnDk7U0o6pHy9l56DYVsiluXegiY6twB4o7OWsrqTb+gVvzK65FfP+NBVVzxY8UzcjbqC51yvO/9wnpUsIBqD/Gvi1gEqvw7RHwVEhdzsvLwlL22G8CfDxHnWLww39j8uRJsmoNiKJly3BcsZkLd9g==";

    public String getName() {
        return "NetscapeCertRequest";
    }

    public TestResult perform() {
        try {
            String challenge = "fixed-for-now";
            byte[] data = Base64.decode(test1);
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(data));
            ASN1Sequence spkac = (ASN1Sequence)in.readObject();
            NetscapeCertRequest nscr = new NetscapeCertRequest(spkac);
            if (!nscr.verify(challenge)) {
                return new SimpleTestResult(false, this.getName() + ": 1 - not verified");
            }
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(nscr.getKeyAlgorithm().getObjectId().getId(), "BC");
            kpg.initialize(1024);
            KeyPair kp = kpg.genKeyPair();
            nscr.setPublicKey(kp.getPublic());
            nscr.sign(kp.getPrivate());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream deros = new DEROutputStream(baos);
            deros.writeObject(nscr);
            deros.close();
            ASN1InputStream in2 = new ASN1InputStream(new ByteArrayInputStream(baos.toByteArray()));
            ASN1Sequence spkac2 = (ASN1Sequence)in2.readObject();
            NetscapeCertRequest nscr2 = new NetscapeCertRequest(spkac2);
            if (!nscr2.verify(challenge)) {
                return new SimpleTestResult(false, this.getName() + ": 2 - not verified");
            }
            challenge = "try it";
            NetscapeCertRequest nscr3 = new NetscapeCertRequest(challenge, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, null), kp.getPublic());
            nscr3.sign(kp.getPrivate());
            if (nscr3.verify(challenge)) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": 3 - not verified");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + e.toString());
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        NetscapeCertRequestTest test = new NetscapeCertRequestTest();
        TestResult result = test.perform();
        System.out.println(((Object)result).toString());
    }
}

