/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.pqc.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McEliecePKCSCipher;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McEliecePKCSDigestCipher;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;
import java.util.Random;

public class McEliecePKCSCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    public String getName() {
        return "McEliecePKCS";
    }

    public void performTest() {
        int numPassesKPG = 1;
        int numPassesEncDec = 10;
        Random rand = new Random();
        for (int j = 0; j < numPassesKPG; ++j) {
            McElieceParameters params = new McElieceParameters();
            McElieceKeyPairGenerator mcElieceKeyGen = new McElieceKeyPairGenerator();
            McElieceKeyGenerationParameters genParam = new McElieceKeyGenerationParameters(this.keyRandom, params);
            mcElieceKeyGen.init(genParam);
            AsymmetricCipherKeyPair pair = mcElieceKeyGen.generateKeyPair();
            ParametersWithRandom param = new ParametersWithRandom(pair.getPublic(), this.keyRandom);
            SHA256Digest msgDigest = new SHA256Digest();
            McEliecePKCSDigestCipher mcEliecePKCSDigestCipher = new McEliecePKCSDigestCipher(new McEliecePKCSCipher(), msgDigest);
            for (int k = 1; k <= numPassesEncDec; ++k) {
                System.out.println("############### test: " + k);
                mcEliecePKCSDigestCipher.init(true, param);
                int mLength = (rand.nextInt() & 0x1F) + 1;
                byte[] mBytes = new byte[mLength];
                rand.nextBytes(mBytes);
                mcEliecePKCSDigestCipher.update(mBytes, 0, mBytes.length);
                byte[] enc = mcEliecePKCSDigestCipher.messageEncrypt();
                mcEliecePKCSDigestCipher.init(false, pair.getPrivate());
                byte[] constructedmessage = mcEliecePKCSDigestCipher.messageDecrypt(enc);
                msgDigest.update(mBytes, 0, mBytes.length);
                byte[] hash = new byte[msgDigest.getDigestSize()];
                msgDigest.doFinal(hash, 0);
                boolean verified = true;
                for (int i = 0; i < hash.length; ++i) {
                    verified = verified && hash[i] == constructedmessage[i];
                }
                if (!verified) {
                    this.fail("en/decryption fails");
                    continue;
                }
                System.out.println("test okay");
                System.out.println();
            }
        }
    }

    public static void main(String[] args) {
        McEliecePKCSCipherTest.runTest(new McEliecePKCSCipherTest());
    }
}

