/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.pqc.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McEliecePointchevalCipher;
import cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McEliecePointchevalDigestCipher;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;
import java.util.Random;

public class McEliecePointchevalCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    public String getName() {
        return "McElieceFujisaki";
    }

    public void performTest() {
        int numPassesKPG = 1;
        int numPassesEncDec = 10;
        Random rand = new Random();
        for (int j = 0; j < numPassesKPG; ++j) {
            McElieceCCA2Parameters params = new McElieceCCA2Parameters();
            McElieceCCA2KeyPairGenerator mcElieceCCA2KeyGen = new McElieceCCA2KeyPairGenerator();
            McElieceCCA2KeyGenerationParameters genParam = new McElieceCCA2KeyGenerationParameters(this.keyRandom, params);
            mcElieceCCA2KeyGen.init(genParam);
            AsymmetricCipherKeyPair pair = mcElieceCCA2KeyGen.generateKeyPair();
            ParametersWithRandom param = new ParametersWithRandom(pair.getPublic(), this.keyRandom);
            SHA256Digest msgDigest = new SHA256Digest();
            McEliecePointchevalDigestCipher mcEliecePointchevalDigestCipher = new McEliecePointchevalDigestCipher(new McEliecePointchevalCipher(), msgDigest);
            for (int k = 1; k <= numPassesEncDec; ++k) {
                System.out.println("############### test: " + k);
                mcEliecePointchevalDigestCipher.init(true, param);
                int mLength = (rand.nextInt() & 0x1F) + 1;
                byte[] mBytes = new byte[mLength];
                rand.nextBytes(mBytes);
                mcEliecePointchevalDigestCipher.update(mBytes, 0, mBytes.length);
                byte[] enc = mcEliecePointchevalDigestCipher.messageEncrypt();
                mcEliecePointchevalDigestCipher.init(false, pair.getPrivate());
                byte[] constructedmessage = mcEliecePointchevalDigestCipher.messageDecrypt(enc);
                msgDigest.update(mBytes, 0, mBytes.length);
                byte[] hash = new byte[msgDigest.getDigestSize()];
                msgDigest.doFinal(hash, 0);
                boolean verified = true;
                for (int i = 0; i < hash.length; ++i) {
                    verified = verified && hash[i] == constructedmessage[i];
                }
                if (!verified) {
                    this.fail("en/decryption fails");
                    continue;
                }
                System.out.println("test okay");
                System.out.println();
            }
        }
    }

    public static void main(String[] args) {
        McEliecePointchevalCipherTest.runTest(new McEliecePointchevalCipherTest());
    }
}

