/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.tsp.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFailureInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.ess.ESSCertID;
import cfca.sadk.org.bouncycastle.asn1.ess.ESSCertIDv2;
import cfca.sadk.org.bouncycastle.asn1.ess.SigningCertificate;
import cfca.sadk.org.bouncycastle.asn1.ess.SigningCertificateV2;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralNames;
import cfca.sadk.org.bouncycastle.asn1.x509.IssuerSerial;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaCertStore;
import cfca.sadk.org.bouncycastle.cms.CMSAttributeTableGenerationException;
import cfca.sadk.org.bouncycastle.cms.CMSAttributeTableGenerator;
import cfca.sadk.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cfca.sadk.org.bouncycastle.tsp.GenTimeAccuracy;
import cfca.sadk.org.bouncycastle.tsp.TSPAlgorithms;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TSPValidationException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequest;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequestGenerator;
import cfca.sadk.org.bouncycastle.tsp.TimeStampResponse;
import cfca.sadk.org.bouncycastle.tsp.TimeStampResponseGenerator;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenGenerator;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import cfca.sadk.org.bouncycastle.tsp.test.SHA1DigestCalculator;
import cfca.sadk.org.bouncycastle.tsp.test.SHA256DigestCalculator;
import cfca.sadk.org.bouncycastle.tsp.test.TSPTestUtil;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.Store;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;

public class NewTSPTest
extends TestCase {
    private static final String BC = "BC";

    public void setUp() {
        Security.addProvider(new BouncyCastleProvider());
    }

    public void testGeneral() throws Exception {
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = TSPTestUtil.makeKeyPair();
        X509Certificate signCert = TSPTestUtil.makeCACertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = TSPTestUtil.makeKeyPair();
        X509Certificate origCert = TSPTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        this.basicTest(origKP.getPrivate(), origCert, certs);
        this.basicSha256Test(origKP.getPrivate(), origCert, certs);
        this.basicTestWithTSA(origKP.getPrivate(), origCert, certs);
        this.overrideAttrsTest(origKP.getPrivate(), origCert, certs);
        this.responseValidationTest(origKP.getPrivate(), origCert, certs);
        this.incorrectHashTest(origKP.getPrivate(), origCert, certs);
        this.badAlgorithmTest(origKP.getPrivate(), origCert, certs);
        this.timeNotAvailableTest(origKP.getPrivate(), origCert, certs);
        this.badPolicyTest(origKP.getPrivate(), origCert, certs);
        this.tokenEncodingTest(origKP.getPrivate(), origCert, certs);
        this.certReqTest(origKP.getPrivate(), origCert, certs);
        this.testAccuracyZeroCerts(origKP.getPrivate(), origCert, certs);
        this.testAccuracyWithCertsAndOrdering(origKP.getPrivate(), origCert, certs);
        this.testNoNonse(origKP.getPrivate(), origCert, certs);
    }

    private void basicTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        NewTSPTest.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }

    private void basicSha256Test(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA256withRSA", privateKey, cert), new SHA256DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA256, new byte[32], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        NewTSPTest.assertEquals((int)0, (int)tsResp.getStatus());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        NewTSPTest.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2));
        SHA256DigestCalculator digCalc = new SHA256DigestCalculator();
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(cert.getEncoded());
        dOut.close();
        byte[] certHash = digCalc.getDigest();
        SigningCertificateV2 sigCertV2 = SigningCertificateV2.getInstance(table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2).getAttributeValues()[0]);
        NewTSPTest.assertTrue((boolean)Arrays.areEqual(certHash, sigCertV2.getCerts()[0].getCertHash()));
    }

    private void overrideAttrsTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSimpleSignerInfoGeneratorBuilder signerInfoGenBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC);
        IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(new X509CertificateHolder(cert.getEncoded()).getIssuer())), cert.getSerialNumber());
        DigestCalculator digCalc = new SHA1DigestCalculator();
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(cert.getEncoded());
        dOut.close();
        byte[] certHash = digCalc.getDigest();
        digCalc = new SHA256DigestCalculator();
        dOut = digCalc.getOutputStream();
        dOut.write(cert.getEncoded());
        dOut.close();
        byte[] certHash256 = digCalc.getDigest();
        final ESSCertID essCertid = new ESSCertID(certHash, issuerSerial);
        final ESSCertIDv2 essCertidV2 = new ESSCertIDv2(certHash256, issuerSerial);
        signerInfoGenBuilder.setSignedAttributeGenerator(new CMSAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                DefaultSignedAttributeTableGenerator attrGen = new DefaultSignedAttributeTableGenerator();
                AttributeTable table = attrGen.getAttributes(parameters);
                table = table.add(PKCSObjectIdentifiers.id_aa_signingCertificate, new SigningCertificate(essCertid));
                table = table.add(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new SigningCertificateV2(new ESSCertIDv2[]{essCertidV2}));
                return table;
            }
        });
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(signerInfoGenBuilder.build("SHA1withRSA", privateKey, cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        NewTSPTest.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
        NewTSPTest.assertNotNull((String)"no signingCertificateV2 attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2));
        SigningCertificate sigCert = SigningCertificate.getInstance(table.get(PKCSObjectIdentifiers.id_aa_signingCertificate).getAttributeValues()[0]);
        NewTSPTest.assertEquals((Object)new X509CertificateHolder(cert.getEncoded()).getIssuer(), (Object)sigCert.getCerts()[0].getIssuerSerial().getIssuer().getNames()[0].getName());
        NewTSPTest.assertEquals((Object)cert.getSerialNumber(), (Object)sigCert.getCerts()[0].getIssuerSerial().getSerial().getValue());
        NewTSPTest.assertTrue((boolean)Arrays.areEqual(certHash, sigCert.getCerts()[0].getCertHash()));
        SigningCertificateV2 sigCertV2 = SigningCertificateV2.getInstance(table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2).getAttributeValues()[0]);
        NewTSPTest.assertEquals((Object)new X509CertificateHolder(cert.getEncoded()).getIssuer(), (Object)sigCertV2.getCerts()[0].getIssuerSerial().getIssuer().getNames()[0].getName());
        NewTSPTest.assertEquals((Object)cert.getSerialNumber(), (Object)sigCertV2.getCerts()[0].getIssuerSerial().getSerial().getValue());
        NewTSPTest.assertTrue((boolean)Arrays.areEqual(certHash256, sigCertV2.getCerts()[0].getCertHash()));
    }

    private void basicTestWithTSA(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setTSA(new GeneralName(new X500Name("CN=Test")));
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        NewTSPTest.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }

    private void responseValidationTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        try {
            request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(101L));
            tsResp.validate(request);
            NewTSPTest.fail((String)"response validation failed on invalid nonce.");
        }
        catch (TSPValidationException e) {
            // empty catch block
        }
        try {
            request = reqGen.generate(TSPAlgorithms.SHA1, new byte[22], BigInteger.valueOf(100L));
            tsResp.validate(request);
            NewTSPTest.fail((String)"response validation failed on wrong digest.");
        }
        catch (TSPValidationException e) {
            // empty catch block
        }
        try {
            request = reqGen.generate(TSPAlgorithms.MD5, new byte[20], BigInteger.valueOf(100L));
            tsResp.validate(request);
            NewTSPTest.fail((String)"response validation failed on wrong digest.");
        }
        catch (TSPValidationException e) {
            // empty catch block
        }
    }

    private void incorrectHashTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[16]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            NewTSPTest.fail((String)"incorrectHash - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            NewTSPTest.fail((String)"incorrectHash - failInfo set to null.");
        }
        if (failInfo.intValue() != 4) {
            NewTSPTest.fail((String)"incorrectHash - wrong failure info returned.");
        }
    }

    private void badAlgorithmTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        JcaSimpleSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build("SHA1withRSA", privateKey, cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(new ASN1ObjectIdentifier("1.2.3.4.5"), new byte[20]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            NewTSPTest.fail((String)"badAlgorithm - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            NewTSPTest.fail((String)"badAlgorithm - failInfo set to null.");
        }
        if (failInfo.intValue() != 128) {
            NewTSPTest.fail((String)"badAlgorithm - wrong failure info returned.");
        }
    }

    private void timeNotAvailableTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        TimeStampResponse tsResp;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(new ASN1ObjectIdentifier("1.2.3.4.5"), new byte[20]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        try {
            tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), null);
        }
        catch (TSPException e) {
            tsResp = tsRespGen.generateRejectedResponse(e);
        }
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            NewTSPTest.fail((String)"timeNotAvailable - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            NewTSPTest.fail((String)"timeNotAvailable - failInfo set to null.");
        }
        if (failInfo.intValue() != 512) {
            NewTSPTest.fail((String)"timeNotAvailable - wrong failure info returned.");
        }
    }

    private void badPolicyTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        TimeStampResponse tsResp;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setReqPolicy(new ASN1ObjectIdentifier("1.1"));
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED, new HashSet());
        try {
            tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        }
        catch (TSPException e) {
            tsResp = tsRespGen.generateRejectedResponse(e);
        }
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            NewTSPTest.fail((String)"badPolicy - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            NewTSPTest.fail((String)"badPolicy - failInfo set to null.");
        }
        if (failInfo.intValue() != 256) {
            NewTSPTest.fail((String)"badPolicy - wrong failure info returned.");
        }
    }

    private void certReqTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(false);
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        NewTSPTest.assertNull((Object)tsToken.getTimeStampInfo().getGenTimeAccuracy());
        NewTSPTest.assertEquals((String)"1.2", (String)tsToken.getTimeStampInfo().getPolicy().getId());
        try {
            tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        }
        catch (TSPValidationException e) {
            NewTSPTest.fail((String)"certReq(false) verification of token failed.");
        }
        Store respCerts = tsToken.getCertificates();
        Collection certsColl = respCerts.getMatches(null);
        if (!certsColl.isEmpty()) {
            NewTSPTest.fail((String)"certReq(false) found certificates in response.");
        }
    }

    private void tokenEncodingTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2.3.4.5.6"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampResponse tsResponse = new TimeStampResponse(tsResp.getEncoded());
        if (!Arrays.areEqual(tsResponse.getEncoded(), tsResp.getEncoded()) || !Arrays.areEqual(tsResponse.getTimeStampToken().getEncoded(), tsResp.getTimeStampToken().getEncoded())) {
            NewTSPTest.fail();
        }
    }

    private void testAccuracyZeroCerts(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setAccuracySeconds(1);
        tsTokenGen.setAccuracyMillis(2);
        tsTokenGen.setAccuracyMicros(3);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        TimeStampTokenInfo tstInfo = tsToken.getTimeStampInfo();
        GenTimeAccuracy accuracy = tstInfo.getGenTimeAccuracy();
        NewTSPTest.assertEquals((int)1, (int)accuracy.getSeconds());
        NewTSPTest.assertEquals((int)2, (int)accuracy.getMillis());
        NewTSPTest.assertEquals((int)3, (int)accuracy.getMicros());
        NewTSPTest.assertEquals((Object)new BigInteger("23"), (Object)tstInfo.getSerialNumber());
        NewTSPTest.assertEquals((String)"1.2", (String)tstInfo.getPolicy().getId());
        Store store = tsToken.getCertificates();
        Collection certificates = store.getMatches(null);
        NewTSPTest.assertEquals((int)0, (int)certificates.size());
    }

    private void testAccuracyWithCertsAndOrdering(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampResponse tsResp;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2.3"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setAccuracySeconds(3);
        tsTokenGen.setAccuracyMillis(1);
        tsTokenGen.setAccuracyMicros(2);
        tsTokenGen.setOrdering(true);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        NewTSPTest.assertTrue((boolean)request.getCertReq());
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        try {
            tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        }
        catch (TSPException e) {
            tsResp = tsRespGen.generateRejectedResponse(e);
        }
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        TimeStampTokenInfo tstInfo = tsToken.getTimeStampInfo();
        GenTimeAccuracy accuracy = tstInfo.getGenTimeAccuracy();
        NewTSPTest.assertEquals((int)3, (int)accuracy.getSeconds());
        NewTSPTest.assertEquals((int)1, (int)accuracy.getMillis());
        NewTSPTest.assertEquals((int)2, (int)accuracy.getMicros());
        NewTSPTest.assertEquals((Object)new BigInteger("23"), (Object)tstInfo.getSerialNumber());
        NewTSPTest.assertEquals((String)"1.2.3", (String)tstInfo.getPolicy().getId());
        NewTSPTest.assertEquals((boolean)true, (boolean)tstInfo.isOrdered());
        NewTSPTest.assertEquals((Object)tstInfo.getNonce(), (Object)BigInteger.valueOf(100L));
        Store store = tsToken.getCertificates();
        Collection certificates = store.getMatches(null);
        NewTSPTest.assertEquals((int)2, (int)certificates.size());
    }

    private void testNoNonse(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2.3"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20]);
        NewTSPTest.assertFalse((boolean)request.getCertReq());
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("24"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        TimeStampTokenInfo tstInfo = tsToken.getTimeStampInfo();
        GenTimeAccuracy accuracy = tstInfo.getGenTimeAccuracy();
        NewTSPTest.assertNull((Object)accuracy);
        NewTSPTest.assertEquals((Object)new BigInteger("24"), (Object)tstInfo.getSerialNumber());
        NewTSPTest.assertEquals((String)"1.2.3", (String)tstInfo.getPolicy().getId());
        NewTSPTest.assertEquals((boolean)false, (boolean)tstInfo.isOrdered());
        NewTSPTest.assertNull((Object)tstInfo.getNonce());
        Store store = tsToken.getCertificates();
        Collection certificates = store.getMatches(null);
        NewTSPTest.assertEquals((int)0, (int)certificates.size());
    }
}

