/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.system.global.FileAndBufferConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class EncryptUtil {
    private static boolean isHex(String str) {
        if (str == null) {
            return false;
        }
        String lowStr = str.toLowerCase();
        int len = lowStr.length();
        for (int i = 0; i < len; ++i) {
            if (lowStr.charAt(i) >= '0' && lowStr.charAt(i) <= '9' || lowStr.charAt(i) >= 'a' && lowStr.charAt(i) <= 'f') continue;
            return false;
        }
        return true;
    }

    private static byte[] HexToByte(String hexStr) throws UnsupportedEncodingException {
        byte[] lowerData = hexStr.toLowerCase().getBytes("UTF-8");
        int len = lowerData.length;
        byte[] workData = null;
        byte[] resultData = null;
        if (len % 2 == 1) {
            workData = new byte[++len];
            workData[0] = 0;
            System.arraycopy(lowerData, 0, workData, 1, len - 1);
        } else {
            workData = new byte[len];
            workData = (byte[])lowerData.clone();
        }
        int resultDataLen = len / 2;
        resultData = new byte[resultDataLen];
        for (int i = 0; i < len; i += 2) {
            byte datum;
            workData[i] = workData[i] >= 48 && workData[i] <= 57 ? (byte)(workData[i] - 48) : (byte)(workData[i] - 87);
            workData[i + 1] = workData[i + 1] >= 48 && workData[i + 1] <= 57 ? (byte)(workData[i + 1] - 48) : (byte)(workData[i + 1] - 87);
            resultData[i / 2] = datum = (byte)(workData[i] << 4 | workData[i + 1]);
        }
        return resultData;
    }

    private static byte[] doWithDES3(byte[] data, String pwd, boolean encryptFlag) throws Exception {
        byte[] ivKey = EncryptUtil.HexToByte(pwd);
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        byte[] iv = new byte[8];
        byte[] key = new byte[24];
        System.arraycopy(ivKey, 0, iv, 0, 8);
        System.arraycopy(ivKey, 8, key, 0, 24);
        CBCParam param = new CBCParam();
        param.setIv(iv);
        algName.setParam(param);
        if (encryptFlag) {
            return RSAAndItsCloseSymAlgUtil.crypto(false, true, key, data, algName);
        }
        return RSAAndItsCloseSymAlgUtil.crypto(false, false, key, data, algName);
    }

    private static byte[] doDES3WithCBC(byte[] data, byte[] iv, byte[] key, boolean ifEncrypt) throws Exception {
        if (iv.length != 8 || key.length != 24) {
            throw new PKIException("iv.length must be 8 bytes and key.length must be 24 bytes!");
        }
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        CBCParam param = new CBCParam();
        param.setIv(iv);
        algName.setParam(param);
        if (ifEncrypt) {
            return RSAAndItsCloseSymAlgUtil.crypto(false, true, key, data, algName);
        }
        return RSAAndItsCloseSymAlgUtil.crypto(false, false, key, data, algName);
    }

    public static byte[] encryptMessageByDES3(byte[] sourceData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] encryptData = EncryptUtil.doWithDES3(sourceData, password, true);
                return Base64.encode(encryptData);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static byte[] encryptMessageByDES3(byte[] sourceData, byte[] iv, byte[] key) throws PKIException {
        try {
            byte[] encryptData = EncryptUtil.doDES3WithCBC(sourceData, iv, key, true);
            return Base64.encode(encryptData);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] decryptMessageByDES3(byte[] encryptData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] decryptedData = EncryptUtil.doWithDES3(Base64.decode(encryptData), password, false);
                return decryptedData;
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static byte[] decryptMessageByDES3(byte[] encryptData, byte[] iv, byte[] key) throws PKIException {
        try {
            byte[] decryptedData = EncryptUtil.doDES3WithCBC(Base64.decode(encryptData), iv, key, false);
            return decryptedData;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageBySM2(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, PublicKey publicKey, Session session) throws PKIException {
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.encryptMessage(mechanism, publicKey, sourceData, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptedData, PrivateKey privateKey, Session session) throws PKIException {
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.decryptMessage(mechanism, privateKey, encryptedData, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageByRSA(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, PublicKey publicKey, Session session) throws PKIException {
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        return EncryptUtil.encrypt(mechanism, publicKey, sourceData, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, PrivateKey privateKey, Session session) throws PKIException {
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        return EncryptUtil.decrypt(mechanism, privateKey, encryptData, session);
    }

    public static void encryptFileBySM2(InputStream plainFileInputStream, OutputStream encryptedFileOutputStream, X509Cert x509Cert, Session session) throws PKIException {
        try {
            byte[] plainData = new byte[plainFileInputStream.available()];
            plainFileInputStream.read(plainData);
            byte[] encryptedData = EncryptUtil.encryptMessageBySM2(plainData, x509Cert, session);
            encryptedFileOutputStream.write(encryptedData);
        }
        catch (IOException e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void encryptFileBySM2(InputStream plainFileInputStream, OutputStream encryptedFileOutputStream, PublicKey publicKey, Session session) throws PKIException {
        try {
            byte[] plainData = new byte[plainFileInputStream.available()];
            plainFileInputStream.read(plainData);
            byte[] encryptedData = EncryptUtil.encryptMessageBySM2(plainData, publicKey, session);
            encryptedFileOutputStream.write(encryptedData);
        }
        catch (IOException e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void decryptFileBySM2(InputStream encryptedFileInputStream, OutputStream decryptedFileOutputStream, PrivateKey privateKey, Session session) throws PKIException {
        try {
            byte[] encryptedData = new byte[encryptedFileInputStream.available()];
            encryptedFileInputStream.read(encryptedData);
            byte[] decryptedData = EncryptUtil.decryptMessageBySM2(encryptedData, privateKey, session);
            decryptedFileOutputStream.write(decryptedData);
        }
        catch (IOException e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void encryptFileByDES3(InputStream plainFileInputStream, OutputStream encryptedFileOutputStream, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam();
                param.setIv(iv);
                EncryptUtil.bigFileBlockEncrypt(true, key, new DESedeEngine(), param, plainFileInputStream, encryptedFileOutputStream);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        } else {
            throw new PKIException("the pwd is not hex string or length is not 64!");
        }
    }

    public static void encryptFileByDES3(InputStream plainFileInputStream, OutputStream encryptedFileOutputStream, byte[] iv, byte[] key) throws PKIException {
        try {
            CBCParam param = new CBCParam();
            param.setIv(iv);
            EncryptUtil.bigFileBlockEncrypt(true, key, new DESedeEngine(), param, plainFileInputStream, encryptedFileOutputStream);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void decryptFileByDES3(InputStream encryptedFileInputStream, OutputStream decryptedFileOutputStream, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam();
                param.setIv(iv);
                EncryptUtil.bigFileBlockEncrypt(false, key, new DESedeEngine(), param, encryptedFileInputStream, decryptedFileOutputStream);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        } else {
            throw new PKIException("the pwd is not hex string or length is not 64!");
        }
    }

    public static void decryptFileByDES3(InputStream encryptedFileInputStream, OutputStream decryptedFileOutputStream, byte[] iv, byte[] key) throws PKIException {
        try {
            CBCParam param = new CBCParam();
            param.setIv(iv);
            EncryptUtil.bigFileBlockEncrypt(false, key, new DESedeEngine(), param, encryptedFileInputStream, decryptedFileOutputStream);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] encryptMessageBySM4(byte[] sourceData, String password) throws PKIException {
        return Base64.encode(EncryptUtil.pbeWithSM4Encrypt(true, password, sourceData));
    }

    public static byte[] encryptMessageBySM4(byte[] sourceData, byte[] iv, byte[] key) throws PKIException {
        return Base64.encode(EncryptUtil.doSM4WithCBC(true, iv, key, sourceData));
    }

    public static byte[] decryptMessageBySM4(byte[] encryptData, String password) throws PKIException {
        return EncryptUtil.pbeWithSM4Encrypt(false, password, Base64.decode(encryptData));
    }

    public static byte[] decryptMessageBySM4(byte[] encryptData, byte[] iv, byte[] key) throws PKIException {
        return EncryptUtil.doSM4WithCBC(false, iv, key, Base64.decode(encryptData));
    }

    public static void encryptFileBySM4(InputStream plainFileInputStream, OutputStream encrytedFileOutputStream, String password) throws PKIException {
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            int dataLen = plainFileInputStream.available();
            plainTextData = new byte[dataLen];
            plainFileInputStream.read(plainTextData);
            encryptTextData = EncryptUtil.pbeWithSM4Encrypt(true, password, plainTextData);
            encrytedFileOutputStream.write(encryptTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void encryptFileBySM4(InputStream plainFileInputStream, OutputStream encrytedFileOutputStream, byte[] iv, byte[] key) throws PKIException {
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            int dataLen = plainFileInputStream.available();
            plainTextData = new byte[dataLen];
            plainFileInputStream.read(plainTextData);
            encryptTextData = EncryptUtil.doSM4WithCBC(true, iv, key, plainTextData);
            encrytedFileOutputStream.write(encryptTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void decryptFileBySM4(InputStream encryptedFileInputStream, OutputStream decryptedFileOutputStream, String password) throws PKIException {
        byte[] decryptedData = null;
        byte[] encryptedData = null;
        try {
            int dataLen = encryptedFileInputStream.available();
            encryptedData = new byte[dataLen];
            encryptedFileInputStream.read(encryptedData);
            decryptedData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptedData);
            decryptedFileOutputStream.write(decryptedData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void decryptFileBySM4(InputStream encryptedFileInputStream, OutputStream decryptedFileOutputStream, byte[] iv, byte[] key) throws PKIException {
        byte[] decryptedData = null;
        byte[] encryptedData = null;
        try {
            int dataLen = encryptedFileInputStream.available();
            encryptedData = new byte[dataLen];
            encryptedFileInputStream.read(encryptedData);
            decryptedData = EncryptUtil.doSM4WithCBC(false, iv, key, encryptedData);
            decryptedFileOutputStream.write(decryptedData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, InputStream is, OutputStream os) throws Exception {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
        cipher.init(encryptFlag, params);
        int readLen = 0;
        byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
        long readTotalLen = 0L;
        long fileLen = is.available();
        int processLen = 0;
        while ((readLen = is.read(buffer)) > 0) {
            if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                os.write(outBytes, 0, processLen);
                continue;
            }
            int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
            int len2 = cipher.doFinal(outBytes, len1);
            os.write(outBytes, 0, len1 + len2);
            break;
        }
    }

    public static byte[] encrypt(Mechanism encryptAlg, Key key, byte[] sourceData, Session session) throws PKIException {
        try {
            return Base64.encode(session.encrypt(encryptAlg, key, sourceData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void encrypt(Mechanism mechanism, Key key, InputStream fileInputStream, OutputStream fileOutputStream, Session session) throws PKIException {
        session.encrypt(mechanism, key, fileInputStream, fileOutputStream);
    }

    public static byte[] encryptMessage(Mechanism encryptAlg, PublicKey publicKey, byte[] sourceData, Session session) throws PKIException {
        try {
            return Base64.encode(session.encryptMessage(encryptAlg, publicKey, sourceData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] decrypt(Mechanism encryptAlg, Key key, byte[] encryptData, Session session) throws PKIException {
        try {
            return session.decrypt(encryptAlg, key, Base64.decode(encryptData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void decrypt(Mechanism mechanism, Key key, InputStream fileInputStream, OutputStream fileOutputStream, Session session) throws PKIException {
        session.decrypt(mechanism, key, fileInputStream, fileOutputStream);
    }

    public static byte[] decryptMessage(Mechanism encryptAlg, Key key, byte[] encryptData, Session session) throws PKIException {
        try {
            return session.decryptMessage(encryptAlg, key, Base64.decode(encryptData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    private static byte[] pbeWithSM4Encrypt(boolean isEncrypted, String pass, byte[] data) throws PKIException {
        try {
            byte[] src = pass.getBytes("UTF8");
            byte[] hash = EncryptUtil.KDF(src);
            byte[] iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            byte[] key = new byte[16];
            System.arraycopy(hash, 16, key, 0, 16);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(isEncrypted, params);
            int len = cipher.getOutputSize(data.length);
            byte[] tempData = new byte[len];
            int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
            int len2 = cipher.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                return removeZeroSourceData;
            }
            return tempData;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    private static byte[] doSM4WithCBC(boolean isEncrypted, byte[] iv, byte[] key, byte[] data) throws PKIException {
        if (iv.length != 16 || key.length != 16) {
            throw new PKIException("iv.length and key.length must be 16 bytes!");
        }
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(isEncrypted, params);
            int len = cipher.getOutputSize(data.length);
            byte[] tempData = new byte[len];
            int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
            int len2 = cipher.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                return removeZeroSourceData;
            }
            return tempData;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    private static byte[] doSM4WithNoPadding(boolean isEncrypt, byte[] input, byte[] key, byte[] iv) throws PKIException {
        try {
            CipherParameters param;
            BufferedBlockCipher cipher = null;
            if (iv != null) {
                param = new ParametersWithIV(new KeyParameter(key), iv);
                cipher = new BufferedBlockCipher(new CBCBlockCipher(new SM4Engine()));
                cipher.init(isEncrypt, param);
            } else {
                param = new KeyParameter(key);
                cipher = new BufferedBlockCipher(new SM4Engine());
                cipher.init(isEncrypt, param);
            }
            int len = cipher.getOutputSize(input.length);
            byte[] out = new byte[len];
            int len1 = cipher.processBytes(input, 0, input.length, out, 0);
            int len2 = cipher.doFinal(out, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] out2 = new byte[total];
                System.arraycopy(out, 0, out2, 0, total);
                return out2;
            }
            return out;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

