/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.CertificateList;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.signature.rsa.RSASignUtil;
import cfca.sadk.signature.sm2.SM2SignUtil;
import cfca.sadk.x509.certificate.CFCAStyle;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;

public class X509CRL {
    private CertificateList certList = null;
    private TBSCertList.CRLEntry[] crlEntries = null;

    public X509CRL(byte[] derCRL) throws PKIException {
        FilterInputStream dis = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(derCRL);
            dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)((ASN1InputStream)dis).readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public X509CRL(CertificateList certList) {
        this.certList = certList;
        this.crlEntries = certList.getTBSCertList().getRevokedCertificates();
    }

    public X509CRL(String x509CRLFilePath) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(x509CRLFilePath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ASN1InputStream dis = null;
        try {
            dis = new ASN1InputStream(fis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
            fis.close();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public X509CRL(InputStream is) throws PKIException {
        ASN1InputStream dis = null;
        try {
            dis = new ASN1InputStream(is);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
            is.close();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public CertificateList getCertificateList() {
        return this.certList;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = ASN1Parser.parseDERObj2Bytes(this.certList);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.ENCODED_CRL, PKIException.ENCODED_CRL_DES, ex);
        }
        return encoded;
    }

    public String getIssuer() {
        X500Name x500IssuerName = this.certList.getIssuer();
        X500Name cfca_issuer = new X500Name(CFCAStyle.INSTANCE, x500IssuerName);
        return cfca_issuer.toString();
    }

    public String getIssuer(X500NameStyle style) {
        X500Name x500IssuerName = this.certList.getIssuer();
        X500Name cfca_issuer = new X500Name(style, x500IssuerName);
        return cfca_issuer.toString();
    }

    public Date getThisUpdate() {
        Time thisUpdate = this.certList.getThisUpdate();
        return thisUpdate.getDate();
    }

    public Date getNextUpdate() {
        Time nextUpdate = this.certList.getNextUpdate();
        if (nextUpdate == null) {
            return null;
        }
        return nextUpdate.getDate();
    }

    public byte[] getSignature() {
        DERBitString derBit = this.certList.getSignature();
        return derBit.getBytes();
    }

    public boolean isRevoke(String certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = new BigInteger(certSerialNumber, 16);
        for (int i = 0; i < this.crlEntries.length; ++i) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (!sn.equals(tmpSN)) continue;
            return true;
        }
        return false;
    }

    public boolean isRevoke(BigInteger certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        for (int i = 0; i < this.crlEntries.length; ++i) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (!certSerialNumber.equals(tmpSN)) continue;
            return true;
        }
        return false;
    }

    public boolean verify(PublicKey pubKey) throws PKIException {
        String digestAlgorithm;
        ASN1ObjectIdentifier oid = this.certList.getSignatureAlgorithm().getAlgorithm();
        if (oid.equals(X9ObjectIdentifiers.sm3WithSM2Encryption)) {
            if (!"SM2".equalsIgnoreCase(pubKey.getAlgorithm())) {
                return false;
            }
            return SM2SignUtil.verify(this.getTBSCertList(), null, this.getSignature(), pubKey);
        }
        if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            digestAlgorithm = "MD5";
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            digestAlgorithm = "SHA-1";
        } else if (oid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
            digestAlgorithm = "SHA-256";
        } else if (oid.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
            digestAlgorithm = "SHA-512";
        } else {
            throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ":" + oid.getId());
        }
        return RSASignUtil.verifySign(digestAlgorithm, pubKey, this.getTBSCertList(), this.getSignature());
    }

    public static boolean verify(String crlPath, String certPath) throws FileNotFoundException, IOException, PKIException {
        if (crlPath != null && !"".equals(crlPath)) {
            try {
                FileInputStream fisCRL = new FileInputStream(crlPath);
                X509CRL crl = new X509CRL(fisCRL);
                fisCRL.close();
                FileInputStream fisCert = new FileInputStream(certPath);
                X509Cert cert = new X509Cert(fisCert);
                fisCert.close();
                boolean result = crl.verify(cert.getPublicKey());
                return result;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (PKIException e) {
                throw e;
            }
        }
        return false;
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.certList.getSignatureAlgorithm();
        ASN1ObjectIdentifier oid = algID.getObjectId();
        boolean isContain = Mechanism.OIDALGMap.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)Mechanism.OIDALGMap.get(oid);
        return sigAlgName;
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.certList.getSignatureAlgorithm();
        ASN1ObjectIdentifier oid = algID.getObjectId();
        return oid.getId();
    }

    public byte[] getTBSCertList() throws PKIException {
        byte[] bTBSCertList = null;
        try {
            bTBSCertList = ASN1Parser.parseDERObj2Bytes(this.certList.getTBSCertList().toASN1Primitive());
        }
        catch (Exception e) {
            throw new PKIException(PKIException.TBSCRL_BYTES, PKIException.TBSCRL_BYTES_DES, e);
        }
        return bTBSCertList;
    }
}

