/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extension;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.signature.rsa.RSASignUtil;
import cfca.sadk.signature.sm2.SM2SignUtil;
import cfca.sadk.system.global.HexCharacter;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.CFCAStyle;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Date;

public class X509Cert {
    private final String head = "-----BEGIN CERTIFICATE-----";
    private final String end = "-----END CERTIFICATE-----";
    protected Certificate cert;
    private Extensions extensions = null;

    public X509Cert(byte[] certData) throws PKIException {
        byte[] derData = this.parseCertData(certData);
        this.initCert(derData);
    }

    public X509Cert(InputStream inputStream) throws PKIException {
        byte[] certIS = null;
        try {
            int i;
            int length = inputStream.available();
            certIS = new byte[length];
            for (int readLen = inputStream.read(certIS); readLen < length; readLen += i) {
                byte[] temp = new byte[length - readLen];
                i = inputStream.read(temp);
                System.arraycopy(temp, 0, certIS, readLen, i);
            }
        }
        catch (IOException ex) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] derData = this.parseCertData(certIS);
        this.initCert(derData);
    }

    public X509Cert(String certFilePath) throws PKIException {
        byte[] certIS = null;
        FileInputStream inputStream = null;
        try {
            int i;
            inputStream = new FileInputStream(certFilePath);
            int length = ((InputStream)inputStream).available();
            certIS = new byte[length];
            for (int readLen = ((InputStream)inputStream).read(certIS); readLen < length; readLen += i) {
                byte[] temp = new byte[length - readLen];
                i = ((InputStream)inputStream).read(temp);
                System.arraycopy(temp, 0, certIS, readLen, i);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, e);
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] derData = this.parseCertData(certIS);
        this.initCert(derData);
    }

    public X509Cert(Certificate certStructure) {
        this.cert = certStructure;
    }

    private byte[] parseCertData(byte[] certData) throws PKIException {
        try {
            int headLength = "-----BEGIN CERTIFICATE-----".length();
            int endLength = "-----END CERTIFICATE-----".length();
            byte[] certHead = new byte[headLength];
            byte[] certEnd = new byte[endLength];
            System.arraycopy(certData, 0, certHead, 0, headLength);
            boolean hasHead = Arrays.equals(certHead, "-----BEGIN CERTIFICATE-----".getBytes());
            if (hasHead) {
                certData = ASN1Parser.deleteCRLF(certData);
            }
            int certDataLength = certData.length;
            System.arraycopy(certData, certDataLength - endLength, certEnd, 0, endLength);
            boolean hasEnd = Arrays.equals(certEnd, "-----END CERTIFICATE-----".getBytes());
            if (!hasHead && !hasEnd) {
                if (ASN1Parser.isBase64Compatability(certData)) {
                    return Base64.decode(certData);
                }
                return certData;
            }
            if (hasHead && hasEnd) {
                byte[] certDataNoHead = new byte[certDataLength - headLength];
                System.arraycopy(certData, headLength, certDataNoHead, 0, certDataNoHead.length);
                byte[] certDataNoHeadNoEnd = new byte[certDataNoHead.length - endLength];
                System.arraycopy(certDataNoHead, 0, certDataNoHeadNoEnd, 0, certDataNoHeadNoEnd.length);
                if (ASN1Parser.isBase64Compatability(certDataNoHeadNoEnd)) {
                    return Base64.decode(certDataNoHeadNoEnd);
                }
                return certDataNoHeadNoEnd;
            }
            if (!hasHead && hasEnd) {
                byte[] certDataNoHeadNoEnd = new byte[certDataLength - endLength];
                System.arraycopy(certData, 0, certDataNoHeadNoEnd, 0, certDataNoHeadNoEnd.length);
                if (ASN1Parser.isBase64Compatability(certDataNoHeadNoEnd)) {
                    return Base64.decode(certDataNoHeadNoEnd);
                }
                return certDataNoHeadNoEnd;
            }
            if (hasHead && !hasEnd) {
                byte[] certDataNoHeadNoEnd = new byte[certDataLength - headLength];
                System.arraycopy(certData, headLength, certDataNoHeadNoEnd, 0, certDataNoHeadNoEnd.length);
                if (ASN1Parser.isBase64Compatability(certDataNoHeadNoEnd)) {
                    return Base64.decode(certDataNoHeadNoEnd);
                }
                return certDataNoHeadNoEnd;
            }
            return certData;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, ex);
        }
    }

    private void initCert(byte[] certData) throws PKIException {
        FilterInputStream asn1InputStream = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certData);
            asn1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence asn1Sequence = (ASN1Sequence)((ASN1InputStream)asn1InputStream).readObject();
            this.cert = Certificate.getInstance(asn1Sequence);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES);
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public Certificate getCertStructure() {
        return this.cert;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = ASN1Parser.parseDERObj2Bytes(this.cert);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.ENCODED_CERT, PKIException.ENCODED_CERT_DES, ex);
        }
        return encoded;
    }

    public ASN1Integer getVersion() {
        return this.cert.getVersion();
    }

    public String getIssuer() {
        X500Name x500IssuerName = this.cert.getIssuer();
        X500Name issuer = new X500Name(CFCAStyle.INSTANCE, x500IssuerName);
        return issuer.toString();
    }

    public String getIssuer(X500NameStyle style) {
        X500Name x500IssuerName = this.cert.getIssuer();
        X500Name issuer = new X500Name(style, x500IssuerName);
        return issuer.toString();
    }

    public X500Name getIssuerX500Name() {
        X500Name x500IssuerName = this.cert.getIssuer();
        return x500IssuerName;
    }

    public String getSubject() {
        X500Name x500SubjectName = this.cert.getSubject();
        X500Name subject = new X500Name(CFCAStyle.INSTANCE, x500SubjectName);
        return subject.toString();
    }

    public String getSubject(X500NameStyle style) {
        X500Name x500SubjectName = this.cert.getSubject();
        X500Name subject = new X500Name(style, x500SubjectName);
        return subject.toString();
    }

    public X500Name getSubjectX500Name() {
        return this.cert.getSubject();
    }

    public Date getNotBefore() {
        Time startTime = this.cert.getStartDate();
        return startTime.getDate();
    }

    public Date getNotAfter() {
        Time endTime = this.cert.getEndDate();
        return endTime.getDate();
    }

    public BigInteger getSerialNumber() {
        ASN1Integer serialNumber = this.cert.getSerialNumber();
        return serialNumber.getPositiveValue();
    }

    public String getStringSerialNumber() {
        ASN1Integer serialNumber = this.cert.getSerialNumber();
        byte[] snData = serialNumber.getPositiveValue().toByteArray();
        if (snData != null) {
            int length = snData.length;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i != length; ++i) {
                int v = snData[i] & 0xFF;
                buf.append(HexCharacter.DIGITS.charAt(v >>> 4));
                buf.append(HexCharacter.DIGITS.charAt(v & 0xF));
            }
            return buf.toString();
        }
        return "";
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        ASN1ObjectIdentifier oid = algID.getAlgorithm();
        boolean isContain = Mechanism.OIDALGMap.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)Mechanism.OIDALGMap.get(oid);
        return sigAlgName;
    }

    private String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        ASN1ObjectIdentifier oid = algID.getAlgorithm();
        return oid.getId();
    }

    public PublicKey getPublicKey() throws PKIException {
        PublicKey publicKey = null;
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        if (X9ObjectIdentifiers.sm3WithSM2Encryption.equals(this.cert.getSignatureAlgorithm().getAlgorithm())) {
            publicKey = this.getSM2PublicKey(spki);
        } else if (PKCSObjectIdentifiers.rsaEncryption.toString().equals(spki.getAlgorithm().getAlgorithm().toString())) {
            publicKey = this.getRSAPublicKey(spki);
        } else {
            throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
        }
        return publicKey;
    }

    private PublicKey getRSAPublicKey(SubjectPublicKeyInfo spki) throws PKIException {
        try {
            RSAKeyParameters param = (RSAKeyParameters)PublicKeyFactory.createKey(spki);
            return new BCRSAPublicKey(param);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES, e);
        }
    }

    private PublicKey getSM2PublicKey(SubjectPublicKeyInfo spki) throws PKIException {
        byte[] pubData = spki.getPublicKeyData().getBytes();
        int len = pubData.length;
        if (len == 65) {
            byte[] pubX = new byte[32];
            byte[] pubY = new byte[32];
            System.arraycopy(pubData, 1, pubX, 0, 32);
            System.arraycopy(pubData, 33, pubY, 0, 32);
            return KeyUtil.getSM2PublicKey(pubX, pubY);
        }
        throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
    }

    public boolean verify(PublicKey pubKey) throws PKIException {
        String digestAlgorithm;
        ASN1ObjectIdentifier oid = this.cert.getSignatureAlgorithm().getAlgorithm();
        if (oid.equals(X9ObjectIdentifiers.sm3WithSM2Encryption)) {
            return SM2SignUtil.verify(this.getTBSCertificate(), null, this.getSignature(), pubKey);
        }
        if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            digestAlgorithm = "MD5";
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            digestAlgorithm = "SHA-1";
        } else if (oid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
            digestAlgorithm = "SHA-256";
        } else if (oid.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
            digestAlgorithm = "SHA-512";
        } else {
            throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ":" + oid.getId());
        }
        return RSASignUtil.verifySign(digestAlgorithm, pubKey, this.getTBSCertificate(), this.getSignature());
    }

    public byte[] getPublicKeyData() throws PKIException {
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        return spki.getPublicKeyData().getBytes();
    }

    public byte[] getTBSCertificate() throws PKIException {
        TBSCertificate tbsCert = this.cert.getTBSCertificate();
        byte[] tbsCertData = null;
        try {
            tbsCertData = ASN1Parser.parseDERObj2Bytes(tbsCert.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.TBSCERT_BYTES, PKIException.TBSCERT_BYTES_DES, ex);
        }
        return tbsCertData;
    }

    public byte[] getSignature() {
        if (this.cert.getSignatureAlgorithm().getAlgorithm().equals(X9ObjectIdentifiers.sm3WithSM2Encryption)) {
            return this.cert.getSignature().getBytes();
        }
        DERBitString signature = this.cert.getSignature();
        return signature.getBytes();
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() throws PKIException {
        ASN1Object derObj = null;
        try {
            derObj = this.getExtensionData(Extension.subjectKeyIdentifier);
            if (derObj == null) {
                return null;
            }
            SubjectKeyIdentifier subjectKeyId = SubjectKeyIdentifier.getInstance(derObj);
            return subjectKeyId;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.CONSTRUCT_SUBJECT_KEY_IDENTIFIER_ERR, PKIException.CONSTRUCT_SUBJECT_KEY_IDENTIFIER_ERR_DES, e);
        }
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() throws PKIException {
        ASN1Object asn1Obj = null;
        try {
            asn1Obj = this.getExtensionData(Extension.authorityKeyIdentifier);
            if (asn1Obj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Obj;
            AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(asn1Sequence);
            return authorityKeyIdentifier;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.CONSTRUCT_AUTHORITY_KEY_IDENTIFIER_ERR, PKIException.CONSTRUCT_AUTHORITY_KEY_IDENTIFIER_ERR_DES, e);
        }
    }

    public ASN1Object getExtensionData(ASN1ObjectIdentifier oid) throws Exception {
        return ASN1Parser.parseBytes2DERObj(this.getExtensionByteData(oid));
    }

    public Extensions getExtensionsData() {
        TBSCertificate tbsCert = this.cert.getTBSCertificate();
        Extensions extensions = tbsCert.getExtensions();
        return extensions;
    }

    public byte[] getExtensionByteData(ASN1ObjectIdentifier oid) throws Exception {
        TBSCertificate tbsCert = this.cert.getTBSCertificate();
        this.extensions = tbsCert.getExtensions();
        if (this.extensions == null) {
            return null;
        }
        Extension extension = this.extensions.getExtension(oid);
        if (extension == null) {
            return null;
        }
        return extension.getExtnValue().getOctets();
    }

    public CRLDistPoint getCRLDistributionPoints() throws PKIException {
        ASN1Object derObj = null;
        try {
            derObj = this.getExtensionData(X509Extension.cRLDistributionPoints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            CRLDistPoint crlDistributPoints = CRLDistPoint.getInstance(asn1Sequence);
            return crlDistributPoints;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.CONSTRUCT_CRL_DIST_POINT_ERR, PKIException.CONSTRUCT_CRL_DIST_POINT_ERR_DES, e);
        }
    }

    private byte[] getSM2Signature() {
        DERBitString signature = this.cert.getSignature();
        byte[] rawSignature = signature.getBytes();
        byte[] trueSignature = new byte[64];
        int i = 0;
        for (i = 0; i < rawSignature.length && rawSignature[i] != 2; ++i) {
        }
        if (i == rawSignature.length) {
            return null;
        }
        int pos = i + 1;
        try {
            byte firstTagLen = rawSignature[pos];
            if (firstTagLen == 32) {
                System.arraycopy(rawSignature, pos + 1, trueSignature, 0, 32);
                pos += 32;
            } else if (firstTagLen == 33) {
                System.arraycopy(rawSignature, pos + 2, trueSignature, 0, 32);
                pos += 33;
            }
            byte secondTagLen = rawSignature[pos + 2];
            if (secondTagLen == 32) {
                System.arraycopy(rawSignature, pos + 3, trueSignature, 32, 32);
            } else if (secondTagLen == 33) {
                System.arraycopy(rawSignature, pos + 4, trueSignature, 32, 32);
            }
        }
        catch (Exception e) {
            return null;
        }
        return trueSignature;
    }

    public BasicConstraints getBasicConstraints() throws PKIException {
        ASN1Object derObj = null;
        try {
            derObj = this.getExtensionData(X509Extension.basicConstraints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            BasicConstraints basicConstraints = BasicConstraints.getInstance(asn1Sequence);
            return basicConstraints;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.CONSTRUCT_BASIC_CONSTRAINTS_ERR, PKIException.CONSTRUCT_BASIC_CONSTRAINTS_ERR_DES, e);
        }
    }
}

