/*
 * Decompiled with CFR 0.152.
 */
package com.db.share.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.db.share.bean.PlatformConfigBean;
import com.db.share.interfaces.ShareCallBack;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.media.UMEmoji;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMMin;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMWeb;
import com.umeng.socialize.media.UMusic;
import java.util.Map;

public class ShareUtil {
    private static final int REQUEST_CODE = 123;
    private static final String TAG = "ShareUtil";

    public static void init(Context context, String appKey, boolean logEnabled) {
        UMConfigure.init((Context)context, (String)appKey, (String)"umeng", (int)1, (String)"");
        UMConfigure.setLogEnabled((boolean)logEnabled);
    }

    public static void requestPermission(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            String[] mPermissionList = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.CALL_PHONE", "android.permission.READ_LOGS", "android.permission.READ_PHONE_STATE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.SET_DEBUG_APP", "android.permission.SYSTEM_ALERT_WINDOW", "android.permission.GET_ACCOUNTS", "android.permission.WRITE_APN_SETTINGS"};
            ActivityCompat.requestPermissions((Activity)activity, (String[])mPermissionList, (int)123);
        }
    }

    public static void dealPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public static void shareText(Activity activity, String text, boolean needDisplay, ShareCallBack shareListener, SHARE_MEDIA ... platforms) {
        if (needDisplay) {
            new ShareAction(activity).withText(text).setDisplayList(platforms).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(platforms[0]).withText(text).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareImage(Activity activity, Bitmap bitmap, boolean needDisplay, ShareCallBack shareListener, SHARE_MEDIA ... platforms) {
        UMImage thumbImage = new UMImage((Context)activity, bitmap);
        UMImage image = new UMImage((Context)activity, bitmap);
        image.setThumb(thumbImage);
        if (needDisplay) {
            new ShareAction(activity).withMedia(image).setDisplayList(platforms).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(platforms[0]).withMedia(image).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareTextWithImages(Activity activity, String text, boolean needDisplay, ShareCallBack shareListener, SHARE_MEDIA platform, UMImage ... image) {
        if (needDisplay) {
            new ShareAction(activity).withText(text).withMedias(image).setDisplayList(new SHARE_MEDIA[]{platform}).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(platform).withText(text).withMedias(image).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareWithLink(Activity activity, String webUrl, String title, String imageUrl, String desc, boolean needDisplay, ShareCallBack shareListener, SHARE_MEDIA ... platforms) {
        UMWeb web = new UMWeb(webUrl);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            web.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            web.setThumb(ShareUtil.createUMImage(activity, imageUrl));
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            web.setDescription(desc);
        }
        if (needDisplay) {
            new ShareAction(activity).withMedia(web).setDisplayList(platforms).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(platforms[0]).withMedia(web).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareWithVideo(Activity activity, String videoUrl, String title, String imageUrl, String desc, boolean needDisplay, ShareCallBack shareListener, SHARE_MEDIA ... platforms) {
        UMVideo video = new UMVideo(videoUrl);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            video.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            video.setThumb(ShareUtil.createUMImage(activity, imageUrl));
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            video.setDescription(desc);
        }
        if (needDisplay) {
            new ShareAction(activity).withMedia(video).setDisplayList(platforms).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(platforms[0]).withMedia(video).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareWithAudio(Activity activity, String audioUrl, String title, String imageUrl, String desc, String targetUrl, boolean needDisplay, ShareCallBack shareListener, SHARE_MEDIA ... platforms) {
        UMusic music = new UMusic(audioUrl);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            music.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            music.setThumb(ShareUtil.createUMImage(activity, imageUrl));
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            music.setDescription(desc);
        }
        if (!TextUtils.isEmpty((CharSequence)targetUrl)) {
            music.setmTargetUrl(targetUrl);
        }
        if (needDisplay) {
            new ShareAction(activity).withMedia(music).setDisplayList(platforms).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(platforms[0]).withMedia(music).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareWithGif(Activity activity, String gifUrl, String title, String imageUrl, String desc, boolean needDisplay, ShareCallBack shareListener) {
        UMEmoji emoji = new UMEmoji((Context)activity, gifUrl);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            emoji.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            emoji.setThumb(ShareUtil.createUMImage(activity, imageUrl));
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            emoji.setDescription(desc);
        }
        if (needDisplay) {
            new ShareAction(activity).withMedia(emoji).setDisplayList(new SHARE_MEDIA[]{SHARE_MEDIA.WEIXIN}).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(SHARE_MEDIA.WEIXIN).withMedia(emoji).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void shareWithMin(Activity activity, String minUrl, String title, String imageUrl, String desc, String path, String username, boolean needDisplay, ShareCallBack shareListener) {
        UMMin min = new UMMin(minUrl);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            min.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            min.setThumb(ShareUtil.createUMImage(activity, imageUrl));
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            min.setDescription(desc);
        }
        if (!TextUtils.isEmpty((CharSequence)path)) {
            min.setPath(path);
        }
        if (!TextUtils.isEmpty((CharSequence)username)) {
            min.setUserName(username);
        }
        if (needDisplay) {
            new ShareAction(activity).withMedia(min).setDisplayList(new SHARE_MEDIA[]{SHARE_MEDIA.WEIXIN}).setCallback(ShareUtil.createShareListener(shareListener)).open();
        } else {
            new ShareAction(activity).setPlatform(SHARE_MEDIA.WEIXIN).withMedia(min).setCallback(ShareUtil.createShareListener(shareListener)).share();
        }
    }

    public static void authLogin(Activity context, int sharemedia, final ShareCallBack shareListener) {
        UMShareAPI.get((Context)context).getPlatformInfo(context, ShareUtil.getShareMedia(sharemedia), new UMAuthListener(){

            public void onStart(SHARE_MEDIA share_media) {
                shareListener.onResult();
            }

            public void onComplete(SHARE_MEDIA share_media, int i, Map<String, String> map) {
                shareListener.onComplete(i, map);
            }

            public void onError(SHARE_MEDIA share_media, int i, Throwable throwable) {
                shareListener.onError(throwable);
            }

            public void onCancel(SHARE_MEDIA share_media, int i) {
                shareListener.onCancel();
            }
        });
    }

    private static UMImage createUMImage(Activity activity, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (url.startsWith("http")) {
            return new UMImage((Context)activity, url);
        }
        if (url.startsWith("/")) {
            return new UMImage((Context)activity, url);
        }
        if (url.startsWith("res")) {
            return new UMImage((Context)activity, ResContainer.getResourceId((Context)activity, (String)"drawable", (String)url.replace("res/", "")));
        }
        return new UMImage((Context)activity, url);
    }

    public static UMShareListener createShareListener(final ShareCallBack successCallback) {
        return new UMShareListener(){

            public void onStart(SHARE_MEDIA share_media) {
                successCallback.onStart();
            }

            public void onResult(SHARE_MEDIA share_media) {
                successCallback.onResult();
            }

            public void onError(SHARE_MEDIA share_media, Throwable throwable) {
                successCallback.onError(throwable);
            }

            public void onCancel(SHARE_MEDIA share_media) {
                successCallback.onCancel();
            }
        };
    }

    public static SHARE_MEDIA getShareMedia(int num) {
        switch (num) {
            case 0: {
                return SHARE_MEDIA.QQ;
            }
            case 1: {
                return SHARE_MEDIA.SINA;
            }
            case 2: {
                return SHARE_MEDIA.WEIXIN;
            }
            case 3: {
                return SHARE_MEDIA.WEIXIN_CIRCLE;
            }
            case 4: {
                return SHARE_MEDIA.QZONE;
            }
            case 5: {
                return SHARE_MEDIA.EMAIL;
            }
            case 6: {
                return SHARE_MEDIA.SMS;
            }
            case 7: {
                return SHARE_MEDIA.FACEBOOK;
            }
            case 8: {
                return SHARE_MEDIA.TWITTER;
            }
            case 9: {
                return SHARE_MEDIA.WEIXIN_FAVORITE;
            }
            case 10: {
                return SHARE_MEDIA.GOOGLEPLUS;
            }
            case 11: {
                return SHARE_MEDIA.RENREN;
            }
            case 12: {
                return SHARE_MEDIA.TENCENT;
            }
            case 13: {
                return SHARE_MEDIA.DOUBAN;
            }
            case 14: {
                return SHARE_MEDIA.FACEBOOK_MESSAGER;
            }
            case 15: {
                return SHARE_MEDIA.YIXIN;
            }
            case 16: {
                return SHARE_MEDIA.YIXIN_CIRCLE;
            }
            case 17: {
                return SHARE_MEDIA.INSTAGRAM;
            }
            case 18: {
                return SHARE_MEDIA.PINTEREST;
            }
            case 19: {
                return SHARE_MEDIA.EVERNOTE;
            }
            case 20: {
                return SHARE_MEDIA.POCKET;
            }
            case 21: {
                return SHARE_MEDIA.LINKEDIN;
            }
            case 22: {
                return SHARE_MEDIA.FOURSQUARE;
            }
            case 23: {
                return SHARE_MEDIA.YNOTE;
            }
            case 24: {
                return SHARE_MEDIA.WHATSAPP;
            }
            case 25: {
                return SHARE_MEDIA.LINE;
            }
            case 26: {
                return SHARE_MEDIA.FLICKR;
            }
            case 27: {
                return SHARE_MEDIA.TUMBLR;
            }
            case 28: {
                return SHARE_MEDIA.ALIPAY;
            }
            case 29: {
                return SHARE_MEDIA.KAKAO;
            }
            case 30: {
                return SHARE_MEDIA.DROPBOX;
            }
            case 31: {
                return SHARE_MEDIA.VKONTAKTE;
            }
            case 32: {
                return SHARE_MEDIA.DINGTALK;
            }
            case 33: {
                return SHARE_MEDIA.MORE;
            }
        }
        return SHARE_MEDIA.WEIXIN;
    }

    public static class Builder {
        PlatformConfigBean WxConfigBean;
        PlatformConfigBean WeiboConfigBean;
        PlatformConfigBean QQConfigBean;

        public Builder setWeixin(PlatformConfigBean platformConfigBean) {
            this.WxConfigBean = platformConfigBean;
            return this;
        }

        public Builder setSinaWeibo(PlatformConfigBean platformConfigBean) {
            this.WeiboConfigBean = platformConfigBean;
            return this;
        }

        public Builder setQQZone(PlatformConfigBean platformConfigBean) {
            this.QQConfigBean = platformConfigBean;
            return this;
        }

        public void build() {
            if (this.WxConfigBean != null) {
                PlatformConfig.setWeixin((String)this.WxConfigBean.getAppId(), (String)this.WxConfigBean.getAppKey());
            }
            if (this.QQConfigBean != null) {
                PlatformConfig.setQQZone((String)this.QQConfigBean.getAppId(), (String)this.QQConfigBean.getAppKey());
            }
            if (this.WeiboConfigBean != null) {
                PlatformConfig.setSinaWeibo((String)this.WeiboConfigBean.getAppId(), (String)this.WeiboConfigBean.getAppKey(), (String)this.WeiboConfigBean.getRedirectUrl());
            }
        }
    }
}

