/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.qq.handler;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMWeb;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.UmengText;

public class UmengQQShareContent
extends SimpleShareContent {
    public UmengQQShareContent(ShareContent shareContent) {
        super(shareContent);
    }

    public Bundle getBundle(boolean isHideQzone, String appName) {
        Bundle bundle = null;
        if (this.getmStyle() == 2 || this.getmStyle() == 3) {
            bundle = this.buildImageBundle();
        } else if (this.getmStyle() == 4) {
            bundle = this.buildMusicBundle();
        } else if (this.getmStyle() == 16) {
            bundle = this.buildWebBundle();
        } else if (this.getmStyle() == 8) {
            bundle = this.buildVideoBundle();
        } else {
            bundle = this.buildTextBundle();
            bundle.putString("error", UmengText.supportStyle((boolean)false, (String)"text"));
        }
        if (isHideQzone) {
            bundle.putInt("cflag", 2);
        } else {
            bundle.putInt("cflag", 1);
        }
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            bundle.putString("appName", appName);
        }
        return bundle;
    }

    private Bundle buildTextBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("summary", this.getText());
        bundle.putInt("req_type", 1);
        return bundle;
    }

    private Bundle buildVideoBundle() {
        String localpath = null;
        String error = null;
        UMVideo umVideo = this.getVideo();
        if (umVideo.getThumbImage() != null) {
            if (umVideo.getThumbImage().asFileImage() != null) {
                if (this.getUMImageScale(umVideo.getThumbImage()) <= 0) {
                    error = UmengText.IMAGE.SHARECONTENT_THUMB_ERROR;
                }
                localpath = umVideo.getThumbImage().asFileImage().toString();
            } else {
                error = UmengText.QQ.QQ_PERMISSION;
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString("title", this.subString(this.objectSetTitle((BaseMediaObject)umVideo), 45));
        bundle.putString("summary", this.subString(this.objectSetDescription((BaseMediaObject)umVideo), 60));
        bundle.putString("imageUrl", "");
        bundle.putString("imageLocalUrl", localpath);
        bundle.putInt("req_type", 1);
        bundle.putString("targetUrl", umVideo.toUrl());
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }

    private Bundle buildWebBundle() {
        String localpath = null;
        String error = null;
        UMWeb umWeb = this.getUmWeb();
        Bundle bundle = new Bundle();
        if (umWeb.getThumbImage() != null) {
            UMImage t = umWeb.getThumbImage();
            if (t.isUrlMedia()) {
                bundle.putString("imageUrl", t.toUrl());
            } else {
                if (umWeb.getThumbImage().asFileImage() != null) {
                    if (this.getUMImageScale(umWeb.getThumbImage()) <= 0) {
                        error = UmengText.IMAGE.SHARECONTENT_THUMB_ERROR;
                    }
                    localpath = umWeb.getThumbImage().asFileImage().toString();
                } else {
                    error = UmengText.QQ.QQ_PERMISSION;
                }
                bundle.putString("imageLocalUrl", localpath);
            }
        }
        bundle.putString("title", this.subString(this.objectSetTitle((BaseMediaObject)umWeb), 45));
        bundle.putString("summary", this.subString(this.objectSetDescription((BaseMediaObject)umWeb), 60));
        bundle.putInt("req_type", 1);
        bundle.putString("targetUrl", umWeb.toUrl());
        if (TextUtils.isEmpty((CharSequence)this.getUmWeb().toUrl())) {
            bundle.putString("error", UmengText.SHARE.EMPTY_WEB_URL);
        }
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }

    private Bundle buildMusicBundle() {
        String localpath = null;
        String error = null;
        UMusic mMusic = this.getMusic();
        if (mMusic.getThumbImage() != null) {
            if (mMusic.getThumbImage().asFileImage() != null) {
                if (this.getUMImageScale(mMusic.getThumbImage()) <= 0) {
                    error = UmengText.IMAGE.SHARECONTENT_THUMB_ERROR;
                }
                localpath = mMusic.getThumbImage().asFileImage().toString();
            } else {
                error = UmengText.QQ.QQ_PERMISSION;
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString("title", this.subString(this.objectSetTitle((BaseMediaObject)mMusic), 45));
        bundle.putString("summary", this.subString(this.objectSetDescription((BaseMediaObject)mMusic), 60));
        bundle.putString("imageUrl", "");
        bundle.putString("imageLocalUrl", localpath);
        bundle.putInt("req_type", 2);
        bundle.putString("targetUrl", mMusic.getmTargetUrl());
        bundle.putString("audio_url", mMusic.toUrl());
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }

    private Bundle buildImageBundle() {
        String localpath = null;
        String error = null;
        Bundle bundle = new Bundle();
        if (this.getImage() != null && this.getImage().asFileImage() != null) {
            if (this.getUMImageScale(this.getImage()) <= 0) {
                error = UmengText.IMAGE.SHARECONTENT_IMAGE_ERROR;
            }
            localpath = this.getImage().asFileImage().toString();
        } else {
            error = UmengText.QQ.QQ_PERMISSION;
        }
        bundle.putString("summary", this.getText());
        bundle.putString("imageLocalUrl", localpath);
        bundle.putInt("req_type", 5);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }
}

