/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BaseMediaObject
implements Parcelable {
    public static final int MEDIA_TYPE_TEXT = 1;
    public static final int MEDIA_TYPE_IMAGE = 2;
    public static final int MEDIA_TYPE_MUSIC = 3;
    public static final int MEDIA_TYPE_VIDEO = 4;
    public static final int MEDIA_TYPE_WEBPAGE = 5;
    public static final int MEDIA_TYPE_VOICE = 6;
    public static final int MEDIA_TYPE_CMD = 7;
    public String actionUrl;
    public String schema;
    public String identify;
    public String title;
    public String description;
    public byte[] thumbData;

    public BaseMediaObject() {
    }

    public BaseMediaObject(Parcel parcel) {
        this.actionUrl = parcel.readString();
        this.schema = parcel.readString();
        this.identify = parcel.readString();
        this.title = parcel.readString();
        this.description = parcel.readString();
        this.thumbData = parcel.createByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setThumbImage(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.actionUrl);
        parcel.writeString(this.schema);
        parcel.writeString(this.identify);
        parcel.writeString(this.title);
        parcel.writeString(this.description);
        parcel.writeByteArray(this.thumbData);
    }

    public abstract int getObjType();

    protected boolean checkArgs() {
        if (this.actionUrl != null && this.actionUrl.length() <= 512) {
            if (this.identify != null && this.identify.length() <= 512) {
                if (this.thumbData != null && this.thumbData.length <= 32768) {
                    if (this.title != null && this.title.length() <= 512) {
                        return this.description != null && this.description.length() <= 1024;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected abstract BaseMediaObject toExtraMediaObject(String var1);

    protected abstract String toExtraMediaString();
}

