/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.umeng.socialize.Config;
import com.umeng.socialize.common.SocializeConstants;
import com.umeng.socialize.net.dplus.cache.DplueCache;
import com.umeng.socialize.utils.SLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SocializeUtils {
    protected static final String TAG = "SocializeUtils";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static Set<Uri> deleteUris = new HashSet<Uri>();
    private static Pattern mDoubleByte_Pattern = null;
    private static int smDip = 0;

    public static String getAppkey(Context context) {
        if (context == null) {
            return "";
        }
        String string = SocializeConstants.APPKEY;
        if (TextUtils.isEmpty((CharSequence)string)) {
            try {
                Object object;
                PackageManager packageManager = context.getPackageManager();
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
                if (applicationInfo != null && (object = applicationInfo.metaData.get("UMENG_APPKEY")) != null) {
                    string = object.toString();
                }
            }
            catch (Exception exception) {
                SLog.error(exception);
            }
        }
        return string;
    }

    public static void safeCloseDialog(Dialog dialog) {
        try {
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
                dialog = null;
            }
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
    }

    public static void openApplicationMarket(Context context, String string) throws Exception {
        if (Config.isJumptoAppStore) {
            String string2 = "market://details?id=" + string;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            context.startActivity(intent);
        }
    }

    public static void safeShowDialog(Dialog dialog) {
        try {
            if (dialog != null && !dialog.isShowing()) {
                dialog.show();
            }
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
    }

    public static Bundle parseUrl(String string) {
        try {
            URL uRL = new URL(string);
            Bundle bundle = SocializeUtils.decodeUrl(uRL.getQuery());
            bundle.putAll(SocializeUtils.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (MalformedURLException malformedURLException) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String string) {
        Bundle bundle = new Bundle();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=");
                bundle.putString(URLDecoder.decode(stringArray2[0]), URLDecoder.decode(stringArray2[1]));
            }
        }
        return bundle;
    }

    public static int countContentLength(String string) {
        string = string.trim();
        int n = 0;
        int n2 = 0;
        Pattern pattern = SocializeUtils.getDoubleBytePattern();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ++n2;
        }
        n = string.length() - n2;
        n2 = n % 2 != 0 ? (n2 += (n + 1) / 2) : (n2 += n / 2);
        return n2;
    }

    private static Pattern getDoubleBytePattern() {
        if (mDoubleByte_Pattern == null) {
            mDoubleByte_Pattern = Pattern.compile("[^\\x00-\\xff]");
        }
        return mDoubleByte_Pattern;
    }

    public static int[] getFloatWindowSize(Context context) {
        if (context == null) {
            return new int[2];
        }
        int[] nArray = new int[]{580, 350};
        return nArray;
    }

    public static boolean isFloatWindowStyle(Context context) {
        if (context == null) {
            return false;
        }
        if (SocializeConstants.SUPPORT_PAD) {
            if (smDip == 0) {
                int n;
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                int n2 = display.getWidth();
                int n3 = n2 > (n = display.getHeight()) ? n : n2;
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                smDip = (int)((float)n3 / displayMetrics.density + 0.5f);
            }
            int n = context.getResources().getConfiguration().screenLayout;
            if ((n &= 0xF) >= 3 && smDip >= 550) {
                return true;
            }
        }
        return false;
    }

    public static Uri insertImage(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string) || !new File(string).exists()) {
            return null;
        }
        try {
            String string2 = MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)string, (String)"umeng_social_shareimg", null);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Uri uri = Uri.parse((String)string2);
            return uri;
        }
        catch (Throwable throwable) {
            SLog.error(throwable);
            return null;
        }
    }

    public static int dip2Px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static Map<String, String> jsonToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject.get(string2) + "");
            }
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
        return hashMap;
    }

    public static byte[] File2byte(File file) {
        byte[] byArray = null;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = fileInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            fileInputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            SLog.error(fileNotFoundException);
        }
        catch (IOException iOException) {
            SLog.error(iOException);
        }
        return byArray;
    }

    public static Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set set = bundle.keySet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : set) {
            if (string.equals("com.sina.weibo.intent.extra.USER_ICON")) {
                hashMap.put("icon_url", bundle.getString(string));
            }
            hashMap.put(string, bundle.getString(string));
        }
        return hashMap;
    }

    public static Bundle mapToBundle(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            bundle.putString(string, map.get(string));
        }
        return bundle;
    }

    public static boolean assertBinaryInvalid(byte[] byArray) {
        return byArray != null && byArray.length > 0;
    }

    public static boolean isToday(long l) {
        int n;
        Calendar calendar = Calendar.getInstance();
        Date date = new Date(System.currentTimeMillis());
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        Date date2 = new Date(l);
        calendar2.setTime(date2);
        return calendar2.get(1) == calendar.get(1) && (n = calendar2.get(6) - calendar.get(6)) == 0;
    }

    public static boolean isHasDplusCache() {
        File file = DplueCache.getFilePath("s_e");
        File file2 = DplueCache.getFilePath("auth");
        File file3 = DplueCache.getFilePath("userinfo");
        File file4 = DplueCache.getFilePath("dau");
        File file5 = DplueCache.getFilePath("stats");
        boolean bl = false;
        if (file != null && file.listFiles() != null && file.listFiles().length > 0 || file2 != null && file2.listFiles() != null && file2.listFiles().length > 0 || file3 != null && file3.listFiles() != null && file3.listFiles().length > 0 || file4 != null && file4.listFiles() != null && file4.listFiles().length > 0 || file5 != null && file5.listFiles() != null && file5.listFiles().length > 0) {
            bl = true;
        }
        return bl;
    }

    public static String hexdigest(String string) {
        String string2 = null;
        try {
            string2 = SocializeUtils.md5(string.getBytes());
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
        return string2;
    }

    public static String md5(byte[] byArray) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            char[] cArray = new char[32];
            int n = 0;
            for (int i = 0; i < 16; ++i) {
                byte by = byArray2[i];
                cArray[n++] = hexDigits[by >>> 4 & 0xF];
                cArray[n++] = hexDigits[by & 0xF];
            }
            string = new String(cArray);
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
        return string;
    }
}

