/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.idtracking;

import android.content.Context;
import android.content.SharedPreferences;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.proguard.b;
import com.umeng.commonsdk.proguard.h;
import com.umeng.commonsdk.proguard.u;
import com.umeng.commonsdk.statistics.common.DataHelper;
import com.umeng.commonsdk.statistics.common.DeviceConfig;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.File;
import org.json.JSONObject;

public class Envelope {
    private final byte[] SEED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final int CODEX_ENCRYPT = 1;
    private final int CODEX_NORMAL = 0;
    private String mVersion = "1.0";
    private String mAddress = null;
    private byte[] mSignature = null;
    private byte[] mGuid = null;
    private byte[] mChecksum = null;
    private int mSerialNo = 0;
    private int mTimestamp = 0;
    private int mLength = 0;
    private byte[] mEntity = null;
    private byte[] identity = null;
    private boolean encrypt = false;

    private Envelope(byte[] byArray, String string, byte[] byArray2) throws Exception {
        if (byArray == null || byArray.length == 0) {
            throw new Exception("entity is null or empty");
        }
        this.mAddress = string;
        this.mLength = byArray.length;
        this.mEntity = com.umeng.commonsdk.statistics.common.b.a(byArray);
        this.mTimestamp = (int)(System.currentTimeMillis() / 1000L);
        this.identity = byArray2;
    }

    public static String getSignature(Context context) {
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
        if (sharedPreferences == null) {
            return null;
        }
        return sharedPreferences.getString("signature", null);
    }

    public void setSignature(String string) {
        this.mSignature = DataHelper.reverseHexString(string);
    }

    public String getSignature() {
        return DataHelper.toHexString(this.mSignature);
    }

    public void setSerialNumber(int n2) {
        this.mSerialNo = n2;
    }

    public void setEncrypt(boolean bl) {
        this.encrypt = bl;
    }

    public static Envelope genEnvelope(Context context, String string, byte[] byArray) {
        try {
            String string2 = DeviceConfig.getMac(context);
            String string3 = DeviceConfig.getDeviceId(context);
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            String string4 = sharedPreferences.getString("signature", null);
            int n2 = sharedPreferences.getInt("serial", 1);
            Envelope envelope = new Envelope(byArray, string, (string3 + string2).getBytes());
            envelope.setSignature(string4);
            envelope.setSerialNumber(n2);
            envelope.seal();
            sharedPreferences.edit().putInt("serial", n2 + 1).putString("signature", envelope.getSignature()).commit();
            envelope.export(context);
            return envelope;
        }
        catch (Exception exception) {
            b.a(context, exception);
            return null;
        }
    }

    public static Envelope genEncryptEnvelope(Context context, String string, byte[] byArray) {
        try {
            String string2 = DeviceConfig.getMac(context);
            String string3 = DeviceConfig.getDeviceId(context);
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            String string4 = sharedPreferences.getString("signature", null);
            int n2 = sharedPreferences.getInt("serial", 1);
            Envelope envelope = new Envelope(byArray, string, (string3 + string2).getBytes());
            envelope.setEncrypt(true);
            envelope.setSignature(string4);
            envelope.setSerialNumber(n2);
            envelope.seal();
            sharedPreferences.edit().putInt("serial", n2 + 1).putString("signature", envelope.getSignature()).commit();
            envelope.export(context);
            return envelope;
        }
        catch (Exception exception) {
            b.a(context, exception);
            return null;
        }
    }

    public void seal() {
        if (this.mSignature == null) {
            this.mSignature = this.genSignature();
        }
        if (this.encrypt) {
            byte[] byArray = new byte[16];
            try {
                System.arraycopy(this.mSignature, 1, byArray, 0, 16);
                this.mEntity = DataHelper.encrypt(this.mEntity, byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mGuid = this.genGuid(this.mSignature, this.mTimestamp);
        this.mChecksum = this.genCheckSum();
    }

    private byte[] genGuid(byte[] byArray, int n2) {
        byte[] byArray2 = DataHelper.hash(this.identity);
        byte[] byArray3 = DataHelper.hash(this.mEntity);
        int n3 = byArray2.length;
        byte[] byArray4 = new byte[n3 * 2];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray4[i2 * 2] = byArray3[i2];
            byArray4[i2 * 2 + 1] = byArray2[i2];
        }
        byte[] byArray5 = byArray;
        for (int i3 = 0; i3 < 2; ++i3) {
            byArray4[i3] = byArray5[i3];
            byArray4[byArray4.length - i3 - 1] = byArray5[byArray5.length - i3 - 1];
        }
        byte[] byArray6 = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >>> 24)};
        for (int i4 = 0; i4 < byArray4.length; ++i4) {
            byArray4[i4] = (byte)(byArray4[i4] ^ byArray6[i4 % 4]);
        }
        return byArray4;
    }

    private byte[] genSignature() {
        return this.genGuid(this.SEED, (int)(System.currentTimeMillis() / 1000L));
    }

    private byte[] genCheckSum() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DataHelper.toHexString(this.mSignature));
        stringBuilder.append(this.mSerialNo);
        stringBuilder.append(this.mTimestamp);
        stringBuilder.append(this.mLength);
        stringBuilder.append(DataHelper.toHexString(this.mGuid));
        return DataHelper.hash(stringBuilder.toString().getBytes());
    }

    public byte[] toBinary() {
        h h2 = new h();
        h2.a(this.mVersion);
        h2.b(this.mAddress);
        h2.c(DataHelper.toHexString(this.mSignature));
        h2.a(this.mSerialNo);
        h2.b(this.mTimestamp);
        h2.c(this.mLength);
        h2.a(this.mEntity);
        h2.d(this.encrypt ? 1 : 0);
        h2.d(DataHelper.toHexString(this.mGuid));
        h2.e(DataHelper.toHexString(this.mChecksum));
        try {
            return new u().a(h2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void export(Context context) {
        JSONObject jSONObject;
        String string = this.mAddress;
        String string2 = UMEnvelopeBuild.imprintProperty(context, "umid", null);
        String string3 = DataHelper.toHexString(this.mSignature);
        byte[] byArray = new byte[16];
        System.arraycopy(this.mSignature, 2, byArray, 0, 16);
        String string4 = DataHelper.toHexString(DataHelper.hash(byArray));
        try {
            jSONObject = new JSONObject();
            jSONObject.put("appkey", (Object)string);
            if (string2 != null) {
                jSONObject.put("umid", (Object)string2);
            }
            jSONObject.put("signature", (Object)string3);
            jSONObject.put("checksum", (Object)string4);
            File file = new File(context.getFilesDir(), ".umeng");
            if (!file.exists()) {
                file.mkdir();
            }
            HelperUtils.writeFile(new File(file, "exchangeIdentity.json"), jSONObject.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            jSONObject = new JSONObject();
            jSONObject.put("appkey", (Object)string);
            jSONObject.put("channel", (Object)UMUtils.getChannel(context));
            if (string2 != null) {
                jSONObject.put("umid", (Object)HelperUtils.getUmengMD5(string2));
            }
            HelperUtils.writeFile(new File(context.getFilesDir(), "exid.dat"), jSONObject.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("version : %s\n", this.mVersion));
        stringBuilder.append(String.format("address : %s\n", this.mAddress));
        stringBuilder.append(String.format("signature : %s\n", DataHelper.toHexString(this.mSignature)));
        stringBuilder.append(String.format("serial : %s\n", this.mSerialNo));
        stringBuilder.append(String.format("timestamp : %d\n", this.mTimestamp));
        stringBuilder.append(String.format("length : %d\n", this.mLength));
        stringBuilder.append(String.format("guid : %s\n", DataHelper.toHexString(this.mGuid)));
        stringBuilder.append(String.format("checksum : %s ", DataHelper.toHexString(this.mChecksum)));
        stringBuilder.append(String.format("codex : %d", this.encrypt ? 1 : 0));
        return stringBuilder.toString();
    }
}

