/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.utils;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.proguard.b;
import com.umeng.commonsdk.statistics.AnalyticsConstants;
import com.umeng.commonsdk.statistics.common.DeviceConfig;
import com.umeng.commonsdk.statistics.common.MLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.microedition.khronos.opengles.GL10;

public class UMUtils {
    private static final String TAG = "UMUtils";
    private static final String KEY_SHARED_PREFERENCES_NAME = "umeng_common_config";
    private static final String KEY_APP_KEY = "appkey";
    private static final String KEY_LAST_APP_KEY = "last_appkey";
    private static final String KEY_CHANNEL = "channel";
    public static final String UNKNOW = "";
    public static final String MOBILE_NETWORK = "2G/3G";
    public static final String WIFI = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String SD_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final Pattern pattern = Pattern.compile("UTDID\">([^<]+)");

    public static void setLastAppkey(Context context, String string) {
        try {
            if (context == null || string == null) {
                return;
            }
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
            if (sharedPreferences != null) {
                sharedPreferences.edit().putString(KEY_LAST_APP_KEY, string).commit();
            }
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set last app key e is " + exception));
            }
            b.a(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set last app key e is " + throwable));
            }
            b.a(context, throwable);
        }
    }

    public static String getLastAppkey(Context context) {
        try {
            if (context == null) {
                return null;
            }
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
            if (sharedPreferences != null) {
                return sharedPreferences.getString(KEY_LAST_APP_KEY, null);
            }
            return null;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get last app key e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get last app key e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static synchronized void setAppkey(Context context, String string) {
        try {
            if (context == null || string == null) {
                return;
            }
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
            if (sharedPreferences != null) {
                sharedPreferences.edit().putString(KEY_APP_KEY, string).commit();
            }
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set app key e is " + exception));
            }
            b.a(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set app key e is " + throwable));
            }
            b.a(context, throwable);
        }
    }

    public static synchronized String getAppkey(Context context) {
        try {
            if (context == null) {
                return null;
            }
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
            if (sharedPreferences != null) {
                return sharedPreferences.getString(KEY_APP_KEY, null);
            }
            return null;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app key e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app key e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static void setChannel(Context context, String string) {
        try {
            if (context == null || string == null) {
                return;
            }
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
            if (sharedPreferences != null) {
                sharedPreferences.edit().putString(KEY_CHANNEL, string).commit();
            }
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set channel e is " + exception));
            }
            b.a(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("set channel e is " + throwable));
            }
            b.a(context, throwable);
        }
    }

    public static String getChannel(Context context) {
        try {
            if (context == null) {
                return null;
            }
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
            if (sharedPreferences != null) {
                return sharedPreferences.getString(KEY_CHANNEL, null);
            }
            return null;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get channel e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get channel e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static String getUTDID(Context context) {
        try {
            block9: {
                if (context != null) break block9;
                return null;
                {
                    catch (Exception exception) {
                        if (AnalyticsConstants.UM_DEBUG) {
                            Log.e((String)TAG, (String)("get utiid e is " + exception));
                        }
                        return null;
                    }
                }
            }
            try {
                Class<?> clazz = Class.forName("com.ut.device.UTDevice");
                Method method = clazz.getMethod("getUtdid", Context.class);
                return (String)method.invoke(null, context.getApplicationContext());
            }
            catch (Exception exception) {
                return UMUtils.readUTDId(context);
            }
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get utiid e is " + throwable));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUTDId(Context context) {
        String string;
        if (context == null) {
            return null;
        }
        File file = UMUtils.getFile(context);
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            string = UMUtils.parseId(UMUtils.readStreamToString(fileInputStream));
        }
        catch (Throwable throwable) {
            try {
                UMUtils.safeClose(fileInputStream);
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        UMUtils.safeClose(fileInputStream);
        return string;
    }

    private static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String parseId(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String readStreamToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        int n2 = 0;
        StringWriter stringWriter = new StringWriter();
        while (-1 != (n2 = inputStreamReader.read(cArray))) {
            stringWriter.write(cArray, 0, n2);
        }
        return stringWriter.toString();
    }

    private static File getFile(Context context) {
        if (context == null) {
            return null;
        }
        if (!UMUtils.checkPermission(context, SD_PERMISSION)) {
            return null;
        }
        if (Environment.getExternalStorageState().equals("mounted")) {
            File file = Environment.getExternalStorageDirectory();
            try {
                return new File(file.getCanonicalPath(), ".UTSystemConfig/Global/Alvin2.xml");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getGPU(GL10 gL10) {
        try {
            String[] stringArray = new String[2];
            String string = gL10.glGetString(7936);
            String string2 = gL10.glGetString(7937);
            stringArray[0] = string;
            stringArray[1] = string2;
            return stringArray;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("Could not read gpu infor, e is " + exception));
            }
            return new String[0];
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("Could not read gpu infor, e is " + throwable));
            }
            return new String[0];
        }
    }

    public static String getCPU() {
        try {
            String string;
            block12: {
                string = null;
                FileReader fileReader = null;
                BufferedReader bufferedReader = null;
                try {
                    fileReader = new FileReader("/proc/cpuinfo");
                    if (fileReader != null) {
                        try {
                            bufferedReader = new BufferedReader(fileReader, 1024);
                            string = bufferedReader.readLine();
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException iOException) {
                            if (AnalyticsConstants.UM_DEBUG) {
                                Log.e((String)TAG, (String)("Could not read from file /proc/cpuinfo, e is " + iOException));
                            }
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!AnalyticsConstants.UM_DEBUG) break block12;
                    Log.e((String)TAG, (String)("Could not read from file /proc/cpuinfo, e is " + fileNotFoundException));
                }
            }
            if (string != null) {
                int n2 = string.indexOf(58) + 1;
                string = string.substring(n2);
                return string.trim();
            }
            return UNKNOW;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get cpu e is " + exception));
            }
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get cpu e is " + throwable));
            }
            return UNKNOW;
        }
    }

    public static String getImsi(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String string = null;
            if (UMUtils.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                string = telephonyManager.getSubscriberId();
            }
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get imei e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get imei e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static String getRegisteredOperator(Context context) {
        if (context == null) {
            return null;
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String string = null;
            if (UMUtils.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                string = telephonyManager.getNetworkOperator();
            }
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get registered operator e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get registered operator e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static String getNetworkOperatorName(Context context) {
        if (context == null) {
            return null;
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (!UMUtils.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                return UNKNOW;
            }
            if (telephonyManager == null) {
                return UNKNOW;
            }
            return telephonyManager.getNetworkOperatorName();
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get network operator e is " + exception));
            }
            b.a(context, exception);
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get network operator e is " + throwable));
            }
            b.a(context, throwable);
            return UNKNOW;
        }
    }

    public static String getDisplayResolution(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = displayMetrics.widthPixels;
            int n3 = displayMetrics.heightPixels;
            String string = String.valueOf(n3) + "*" + String.valueOf(n2);
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get display resolution e is " + exception));
            }
            b.a(context, exception);
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get display resolution e is " + throwable));
            }
            b.a(context, throwable);
            return UNKNOW;
        }
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOW, UNKNOW};
        if (context == null) {
            return stringArray;
        }
        try {
            if (!UMUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = WIFI;
                return stringArray;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = MOBILE_NETWORK;
                stringArray[1] = networkInfo2.getSubtypeName();
                return stringArray;
            }
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get network access mode e is " + exception));
            }
            b.a(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get network access mode e is " + throwable));
            }
            b.a(context, throwable);
        }
        return stringArray;
    }

    public static boolean isSdCardWrittenable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static Locale getLocale(Context context) {
        if (context == null) {
            return null;
        }
        try {
            Locale locale;
            block10: {
                locale = null;
                try {
                    Configuration configuration = new Configuration();
                    configuration.setToDefaults();
                    Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
                    if (configuration != null) {
                        locale = configuration.locale;
                    }
                }
                catch (Exception exception) {
                    if (!AnalyticsConstants.UM_DEBUG) break block10;
                    Log.e((String)TAG, (String)("fail to read user config locale, e is " + exception));
                }
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return locale;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get locale e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get locale e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static String getMac(Context context) {
        if (context == null) {
            return null;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (UMUtils.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return wifiInfo.getMacAddress();
            }
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)"Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
            }
            return UNKNOW;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get mac e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get mac e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static String getOperator(Context context) {
        if (context == null) {
            return "Unknown";
        }
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get get operator e is " + exception));
            }
            b.a(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get get operator e is " + throwable));
            }
            b.a(context, throwable);
        }
        return "Unknown";
    }

    public static String getSubOSName(Context context) {
        if (context == null) {
            return null;
        }
        try {
            String string = null;
            Properties properties = UMUtils.getBuildProp();
            try {
                string = properties.getProperty(KEY_MIUI_VERSION_NAME);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    if (UMUtils.isFlyMe()) {
                        string = "Flyme";
                    } else if (!TextUtils.isEmpty((CharSequence)UMUtils.getYunOSVersion(properties))) {
                        string = "YunOS";
                    }
                } else {
                    string = "MIUI";
                }
            }
            catch (Exception exception) {
                string = null;
                b.a(context, exception);
            }
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os name e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os name e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static String getSubOSVersion(Context context) {
        if (context == null) {
            return null;
        }
        try {
            String string = null;
            Properties properties = UMUtils.getBuildProp();
            try {
                string = properties.getProperty(KEY_MIUI_VERSION_NAME);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    if (UMUtils.isFlyMe()) {
                        try {
                            string = UMUtils.getFlymeVersion(properties);
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            string = UMUtils.getYunOSVersion(properties);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                string = null;
                b.a(context, exception);
            }
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os version e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get sub os version e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    private static String getYunOSVersion(Properties properties) {
        String string = properties.getProperty("ro.yunos.version");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return null;
    }

    private static String getFlymeVersion(Properties properties) {
        try {
            String string = properties.getProperty("ro.build.display.id").toLowerCase(Locale.getDefault());
            if (string.contains("flyme os")) {
                return string.split(" ")[2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Properties getBuildProp() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private static boolean isFlyMe() {
        try {
            Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getDeviceType(Context context) {
        try {
            String string = "Phone";
            if (context == null) {
                return string;
            }
            boolean bl = (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
            string = bl ? "Tablet" : "Phone";
            return string;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get device type e is " + exception));
            }
            b.a(context, exception);
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get device type e is " + throwable));
            }
            b.a(context, throwable);
            return null;
        }
    }

    public static String getAppVersionCode(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            int n2 = packageInfo.versionCode;
            return String.valueOf(n2);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version code e is " + exception));
            }
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version code e is " + throwable));
            }
            return UNKNOW;
        }
    }

    public static String getAppVersinoCode(Context context, String string) {
        if (context == null || string == null) {
            return UNKNOW;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            int n2 = packageInfo.versionCode;
            return String.valueOf(n2);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version code e is " + exception));
            }
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version code e is " + throwable));
            }
            return UNKNOW;
        }
    }

    public static String getAppVersionName(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version name e is " + (Object)((Object)nameNotFoundException)));
            }
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version name e is " + throwable));
            }
            return UNKNOW;
        }
    }

    public static String getAppVersionName(Context context, String string) {
        if (context == null || string == null) {
            return UNKNOW;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version name e is " + (Object)((Object)nameNotFoundException)));
            }
            b.a(context, nameNotFoundException);
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app version name e is " + throwable));
            }
            b.a(context, throwable);
            return UNKNOW;
        }
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl;
        block7: {
            bl = false;
            if (context == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int n2 = (Integer)method.invoke((Object)context, string);
                    if (n2 == 0) {
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    b.a(context, exception);
                    bl = false;
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager.checkPermission(string, context.getPackageName()) == 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static String byte2HexFormatted(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            int n2 = string.length();
            if (n2 == 1) {
                string = "0" + string;
            }
            if (n2 > 2) {
                string = string.substring(n2 - 2, n2);
            }
            stringBuilder.append(string.toUpperCase());
            if (i2 >= byArray.length - 1) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public static boolean isDebug(Context context) {
        if (context == null) {
            return false;
        }
        try {
            return (context.getApplicationInfo().flags & 2) != 0;
        }
        catch (Exception exception) {
            b.a(context, exception);
            return false;
        }
    }

    public static String getAppName(Context context) {
        String string = null;
        if (context == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app name e is " + exception));
            }
            b.a(context, exception);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get app name e is " + throwable));
            }
            b.a(context, throwable);
        }
        return string;
    }

    public static String MD5(String string) {
        try {
            block10: {
                if (string != null) break block10;
                return null;
            }
            try {
                byte[] byArray = string.getBytes();
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.reset();
                messageDigest.update(byArray);
                byte[] byArray2 = messageDigest.digest();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    stringBuffer.append(String.format("%02X", byArray2[i2]));
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                try {
                    return string.replaceAll("[^[a-z][A-Z][0-9][.][_]]", UNKNOW);
                }
                catch (Exception exception2) {
                    if (AnalyticsConstants.UM_DEBUG) {
                        Log.e((String)TAG, (String)("MD5 e is " + exception2));
                    }
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("MD5 e is " + throwable));
            }
            return null;
        }
    }

    public static String getFileMD5(File file) {
        try {
            MessageDigest messageDigest = null;
            FileInputStream fileInputStream = null;
            byte[] byArray = new byte[1024];
            try {
                int n2;
                if (!file.isFile()) {
                    return UNKNOW;
                }
                messageDigest = MessageDigest.getInstance("MD5");
                fileInputStream = new FileInputStream(file);
                while ((n2 = fileInputStream.read(byArray, 0, 1024)) != -1) {
                    messageDigest.update(byArray, 0, n2);
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                return null;
            }
            BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
            return String.format("%1$032x", bigInteger);
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get file MD5 e is " + exception));
            }
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("get file MD5 e is " + throwable));
            }
            return null;
        }
    }

    public static String encryptBySHA1(String string) {
        try {
            MessageDigest messageDigest = null;
            String string2 = null;
            byte[] byArray = string.getBytes();
            try {
                messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update(byArray);
                string2 = UMUtils.bytes2Hex(messageDigest.digest());
            }
            catch (Exception exception) {
                return null;
            }
            return string2;
        }
        catch (Exception exception) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("encrypt by SHA1 e is " + exception));
            }
            return null;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                Log.e((String)TAG, (String)("encrypt by SHA1 e is " + throwable));
            }
            return null;
        }
    }

    private static String bytes2Hex(byte[] byArray) {
        String string = UNKNOW;
        String string2 = null;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            string2 = Integer.toHexString(byArray[i2] & 0xFF);
            if (string2.length() == 1) {
                string = string + "0";
            }
            string = string + string2;
        }
        return string;
    }

    public static String getUMId(Context context) {
        String string = null;
        try {
            if (context != null) {
                string = UMEnvelopeBuild.imprintProperty(context.getApplicationContext(), "umid", null);
            }
        }
        catch (Exception exception) {
            b.a(context, exception);
        }
        return string;
    }

    public static String getDeviceToken(Context context) {
        String string = null;
        if (context != null) {
            context = context.getApplicationContext();
            try {
                Object object;
                Method method;
                Object object2;
                Method method2;
                Class<?> clazz = Class.forName("com.umeng.message.MessageSharedPrefs");
                if (clazz != null && (method2 = clazz.getMethod("getInstance", Context.class)) != null && (object2 = method2.invoke(clazz, context)) != null && (method = clazz.getMethod("getDeviceToken", new Class[0])) != null && (object = method.invoke(object2, new Object[0])) != null && object instanceof String) {
                    string = (String)object;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getAppkeyByXML(Context context) {
        String string = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                String string2 = applicationInfo.metaData.getString("UMENG_APPKEY");
                if (string2 != null) {
                    string = string2;
                    return string.trim();
                }
                MLog.e("MobclickAgent", "getAppkey failed. the applicationinfo is null!");
            }
        }
        catch (Throwable throwable) {
            MLog.e("MobclickAgent", "Could not read UMENG_APPKEY meta-data from AndroidManifest.xml.", throwable);
        }
        return null;
    }

    public static String getChannelByXML(Context context) {
        String string = null;
        try {
            Object object;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null && (object = applicationInfo.metaData.get("UMENG_CHANNEL")) != null) {
                String string2 = object.toString();
                if (string2 != null) {
                    string = string2;
                    return string.trim();
                }
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i("MobclickAgent", "Could not read UMENG_CHANNEL meta-data from AndroidManifest.xml.");
                }
            }
        }
        catch (Throwable throwable) {
            MLog.e("MobclickAgent", "Could not read UMENG_CHANNEL meta-data from AndroidManifest.xml.", throwable);
        }
        return null;
    }

    public static boolean checkPath(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean checkAndroidManifest(Context context, String string) {
        try {
            ComponentName componentName = new ComponentName(context.getApplicationContext().getPackageName(), string);
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            packageManager.getActivityInfo(componentName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean checkIntentFilterData(Context context, String string) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addCategory("android.intent.category.BROWSABLE");
        String string2 = "tencent" + string + ":";
        Uri uri = Uri.parse((String)string2);
        intent.setData(uri);
        List list = context.getApplicationContext().getPackageManager().queryIntentActivities(intent, 64);
        if (list.size() > 0) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo.activityInfo == null || !resolveInfo.activityInfo.packageName.equals(context.getApplicationContext().getPackageName())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean checkResource(Context context, String string, String string2) {
        int n2 = context.getApplicationContext().getResources().getIdentifier(string, string2, context.getApplicationContext().getPackageName());
        return n2 > 0;
    }

    public static boolean checkMetaData(Context context, String string) {
        PackageManager packageManager = context.getApplicationContext().getPackageManager();
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getApplicationContext().getPackageName(), 128);
            if (applicationInfo != null) {
                Object object = applicationInfo.metaData.get(string);
                return object != null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static String getAppMD5Signature(Context context) {
        String string = DeviceConfig.getAppMD5Signature(context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string = string.replace(":", UNKNOW);
            string = string.toLowerCase();
        }
        return string;
    }

    public static String getAppSHA1Key(Context context) {
        return DeviceConfig.getAppSHA1Key(context);
    }

    public static String getAppHashKey(Context context) {
        return DeviceConfig.getAppHashKey(context);
    }

    public static int getTargetSdkVersion(Context context) {
        return context.getApplicationInfo().targetSdkVersion;
    }

    public static boolean isMainProgress(Context context) {
        boolean bl = false;
        try {
            String string = com.umeng.commonsdk.framework.b.a(context);
            String string2 = context.getApplicationContext().getPackageName();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && string.equals(string2)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isApplication(Context context) {
        boolean bl = false;
        try {
            String string = context.getClass().getSuperclass().getName();
            if (!TextUtils.isEmpty((CharSequence)string) && string.equals("android.app.Application")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

