/*
 * Decompiled with CFR 0.152.
 */
package com.zjtlcb.fcloud.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class SecurityUtil {
    private static final Log log = LogFactory.getLog(SecurityUtil.class);
    private static String tlHttpUrl = "";
    private static String appID = "";
    private static String appSecretKey = "";
    private static String sm2PrivateKey = "";
    private static String sm2PublicKey = "";
    private static String tlPublicKey = "";
    private static String appAccessToken = null;
    private static Long getTokenTime = 0L;
    private static final Long INTERVALTIME = 3540000L;
    private static boolean isStarted = false;

    private SecurityUtil() {
    }

    public static boolean init(String tlHttpUrl, String appID, String appSecretKey, String sm2PrivateKey, String sm2PublicKey, String tlPublicKey) {
        SecurityUtil.tlHttpUrl = tlHttpUrl;
        SecurityUtil.appID = appID;
        SecurityUtil.appSecretKey = appSecretKey;
        SecurityUtil.sm2PrivateKey = sm2PrivateKey;
        SecurityUtil.sm2PublicKey = sm2PublicKey;
        SecurityUtil.tlPublicKey = tlPublicKey;
        if (appAccessToken == null && !SecurityUtil.compareTokenTime()) {
            log.error((Object)"SecurityUtil\u521d\u59cb\u5316\u5931\u8d25");
            return false;
        }
        return true;
    }

    public static String getAppAccessToken() {
        return appAccessToken;
    }

    public static JSONObject toTLBuss(JSONObject reqMsg, String serviceId) {
        try {
            if (!reqMsg.containsKey((Object)"reqData")) {
                log.error((Object)"reqData\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u7a7a");
                return null;
            }
            if (System.currentTimeMillis() - getTokenTime > INTERVALTIME && !SecurityUtil.compareTokenTime()) {
                log.error((Object)"\u66f4\u65b0token\u63a5\u53e3\u5f02\u5e38");
                return null;
            }
            reqMsg.put("appID", (Object)appID);
            reqMsg.put("seqNO", (Object)new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date()));
            reqMsg.put("signMethod", (Object)"SM3");
            reqMsg.put("encryptMethod", (Object)"SM4");
            reqMsg.put("appAccessToken", (Object)appAccessToken);
            log.info((Object)("\u8c03\u7528\u670d\u52a1\uff1a" + serviceId));
            log.info((Object)("\u539f\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString()));
            String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
            reqMsg.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey(randomKey, tlPublicKey));
            reqMsg.put("sm2Sign", (Object)SM2Util.signByPrivateKey(randomKey, sm2PrivateKey, appID));
            reqMsg.put("sign", (Object)SM3Util.sign(reqMsg.getString("reqData") + reqMsg.getString("seqNO") + appSecretKey + randomKey));
            reqMsg.put("reqData", (Object)SM4Util.encrypt(reqMsg.getString("reqData"), reqMsg.getString("seqNO") + reqMsg.getString("appAccessToken") + appSecretKey + randomKey));
            log.info((Object)("TL\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString()));
            String rspMsg = SecurityUtil.doPost(reqMsg.toJSONString(), tlHttpUrl + serviceId);
            log.info((Object)("TL\u54cd\u5e94\u62a5\u6587\uff1a" + rspMsg));
            JSONObject rspJsonObj = JSON.parseObject((String)rspMsg);
            if (rspJsonObj.containsKey((Object)"rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), sm2PrivateKey);
                rspJsonObj.put("sm2EncryptData", (Object)sm2Key);
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tlPublicKey, appID, sm2Key)) {
                    log.info((Object)"\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                    return rspJsonObj;
                }
                String rspData = SM4Util.decrypt(rspJsonObj.getString("rspData"), rspJsonObj.getString("seqNO") + reqMsg.getString("appAccessToken") + appSecretKey + sm2Key);
                if (SM3Util.verify(rspData + rspJsonObj.getString("seqNO") + appSecretKey + sm2Key, rspJsonObj.getString("sign"))) {
                    rspJsonObj.put("rspData", JSONObject.parse((String)rspData));
                    log.info((Object)("\u89e3\u5bc6\u540e\u62a5\u6587\uff1a" + rspJsonObj.toJSONString()));
                    return rspJsonObj;
                }
                log.info((Object)"\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return rspJsonObj;
            }
            if (rspJsonObj.containsKey((Object)"errorCode") && ("000008".equals(rspJsonObj.getString("errorCode")) || "000007".equals(rspJsonObj.getString("errorCode")))) {
                getTokenTime = 0L;
            }
            log.info((Object)"\u4ea4\u6613\u5f02\u5e38");
            return rspJsonObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"\u8c03\u7528\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38");
            return null;
        }
    }

    public static String getTLToken() {
        try {
            JSONObject reqMsg = new JSONObject();
            String seqNO = new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date());
            reqMsg.put("appID", (Object)appID);
            reqMsg.put("seqNO", (Object)seqNO);
            reqMsg.put("random", (Object)MD5Util.md5_(seqNO));
            log.info((Object)"\u8c03\u7528\u670d\u52a1\uff1aapproveDev");
            String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
            reqMsg.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey(randomKey, tlPublicKey));
            reqMsg.put("sm2Sign", (Object)SM2Util.signByPrivateKey(randomKey, sm2PrivateKey, appID));
            reqMsg.put("sign", (Object)SM3Util.sign(reqMsg.getString("random") + reqMsg.getString("seqNO") + appSecretKey + randomKey));
            log.info((Object)("TL\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString()));
            String rspMsg = SecurityUtil.doPost(reqMsg.toJSONString(), tlHttpUrl + "approveDev");
            log.info((Object)("TL\u54cd\u5e94\u62a5\u6587\uff1a" + rspMsg));
            JSONObject rspJsonObj = JSON.parseObject((String)rspMsg);
            String token = "";
            if (rspJsonObj.getString("errorCode").equals("000000")) {
                token = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), sm2PrivateKey);
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tlPublicKey, appID, token)) {
                    log.info((Object)"\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                    return null;
                }
                if (SM3Util.verify(rspJsonObj.getString("random") + rspJsonObj.getString("seqNO") + token + appSecretKey, rspJsonObj.getString("sign"))) {
                    log.info((Object)("\u83b7\u5f97Token\u4e3a\uff1a" + token));
                    if (appAccessToken == null || getTokenTime == 0L) {
                        appAccessToken = token;
                        getTokenTime = System.currentTimeMillis();
                    }
                    rspJsonObj.put("appAccessToken", (Object)token);
                    return token;
                }
                log.info((Object)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return null;
            }
            log.info((Object)"\u4ea4\u6613\u5f02\u5e38");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38");
            return null;
        }
    }

    public static JSONObject decrypt(JSONObject reqJsonObj) {
        try {
            log.info((Object)("\u5f85\u89e3\u5bc6\u62a5\u6587\uff1a" + reqJsonObj));
            if (!reqJsonObj.getString("appID").equals(appID)) {
                log.error((Object)"\u62a5\u6587\u6709\u8bef\uff0cappID\u53c2\u6570\u4e0d\u4e00\u81f4");
                return null;
            }
            if (reqJsonObj.containsKey((Object)"reqData")) {
                String sm2Key = SM2Util.decryptByPrivateKey(reqJsonObj.getString("sm2EncryptData"), sm2PrivateKey);
                reqJsonObj.put("sm2EncryptData", (Object)sm2Key);
                if (!SM2Util.verifyByPublicKey(reqJsonObj.getString("sm2Sign"), tlPublicKey, appID, sm2Key)) {
                    log.info((Object)"\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                    return reqJsonObj;
                }
                String reqData = SM4Util.decrypt(reqJsonObj.getString("reqData"), reqJsonObj.getString("seqNO") + reqJsonObj.getString("appAccessToken") + appSecretKey + sm2Key);
                if (SM3Util.verify(reqData + reqJsonObj.getString("seqNO") + appSecretKey + sm2Key, reqJsonObj.getString("sign"))) {
                    reqJsonObj.put("reqData", JSONObject.parse((String)reqData));
                    log.info((Object)("\u89e3\u5bc6\u540e\u62a5\u6587\uff1a" + reqJsonObj.toJSONString()));
                    return reqJsonObj;
                }
                log.info((Object)"\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return reqJsonObj;
            }
            log.info((Object)"\u62a5\u6587\u7f3a\u5c11reqData,\u4ea4\u6613\u5f02\u5e38");
            return reqJsonObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"\u8c03\u7528\u89e3\u5bc6\u65b9\u6cd5\u5f02\u5e38");
            return null;
        }
    }

    public static JSONObject encrypt(JSONObject rspJsonObj) {
        try {
            if (!rspJsonObj.containsKey((Object)"rspData") || !rspJsonObj.getJSONObject("rspData").containsKey((Object)"head")) {
                log.error((Object)"rspData\u53c2\u6570\u53cahead\u53c2\u6570\u4e0d\u80fd\u7a7a");
                return null;
            }
            String errorCode = rspJsonObj.getJSONObject("rspData").getJSONObject("head").getString("errorCode");
            if (errorCode == null) {
                log.error((Object)"errorCode\u53c2\u6570\u4e0d\u80fd\u7a7a");
                return null;
            }
            rspJsonObj.put("appID", (Object)appID);
            rspJsonObj.put("seqNO", (Object)new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date()));
            rspJsonObj.put("signMethod", (Object)"SM3");
            rspJsonObj.put("encryptMethod", (Object)"SM4");
            rspJsonObj.put("appAccessToken", (Object)"");
            rspJsonObj.put("errorCode", (Object)errorCode);
            rspJsonObj.put("errorMsg", (Object)rspJsonObj.getJSONObject("rspData").getJSONObject("head").getString("errorMsg"));
            log.info((Object)("\u5f85\u52a0\u5bc6\u62a5\u6587\uff1a" + rspJsonObj));
            String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
            rspJsonObj.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey(randomKey, tlPublicKey));
            rspJsonObj.put("sm2Sign", (Object)SM2Util.signByPrivateKey(randomKey, sm2PrivateKey, appID));
            rspJsonObj.put("sign", (Object)SM3Util.sign(rspJsonObj.getString("rspData") + rspJsonObj.getString("seqNO") + appSecretKey + randomKey));
            rspJsonObj.put("rspData", (Object)SM4Util.encrypt(rspJsonObj.getString("rspData"), rspJsonObj.getString("seqNO") + "" + appSecretKey + randomKey));
            log.info((Object)("\u52a0\u5bc6\u540e\u62a5\u6587\uff1a" + rspJsonObj.toJSONString()));
            return rspJsonObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"\u8c03\u7528\u52a0\u5bc6\u65b9\u6cd5\u5f02\u5e38");
            return null;
        }
    }

    private static String doPost(String msg, String url) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        ByteArrayEntity bae = new ByteArrayEntity(msg.getBytes());
        httpPost.setEntity((HttpEntity)bae);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            return new String(bytes, "UTF-8");
        }
        return null;
    }

    @Deprecated
    private static void getTokenSchedule() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                appAccessToken = SecurityUtil.getTLToken();
            }
        };
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(runnable, 0L, 59L, TimeUnit.MINUTES);
    }

    private static synchronized boolean compareTokenTime() {
        if (System.currentTimeMillis() - getTokenTime > INTERVALTIME) {
            getTokenTime = 0L;
            if (SecurityUtil.getTLToken() == null) {
                return false;
            }
        }
        return true;
    }
}

