/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api;

import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcRequest;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.utils.IcbcHashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPIcbcClient
extends DefaultIcbcClient {
    public APPIcbcClient(String appId, String privateKey, String charset, String ca, String password) {
        super(appId, "CA", privateKey, charset, "json", null, null, null, ca, password);
    }

    public APPIcbcClient(String appId, String privateKey, String charset) {
        super(appId, "RSA", privateKey, charset, "json", null, null, null, null, null);
    }

    public String sign(IcbcRequest<?> request) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        return this.sign(request, null, msgId, "");
    }

    public String sign(IcbcRequest<?> request, String msgId) throws IcbcApiException {
        return this.sign(request, null, msgId, "");
    }

    public String sign(IcbcRequest<?> request, IcbcHashMap params) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        return this.sign(request, params, msgId);
    }

    public String sign(IcbcRequest<?> request, IcbcHashMap params, String msgId) throws IcbcApiException {
        return this.sign(request, params, msgId, "");
    }

    public String sign(IcbcRequest<?> request, IcbcHashMap params, String msgId, String appAuthToken) throws IcbcApiException {
        IcbcHashMap ReturnParams = this.prepareParams(request, msgId, appAuthToken);
        ReturnParams.put("service_url", request.getServiceUrl());
        if (params != null && params.size() > 0) {
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                ReturnParams.put(key, (String)entry.getValue());
            }
        }
        return JSON.toJSONString(ReturnParams);
    }
}

