/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api;

import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.IcbcResponse;
import com.icbc.api.internal.util.StringUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.utils.IcbcEncrypt;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.IcbcSignature;
import com.icbc.api.utils.WebUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIcbcClient
implements IcbcClient {
    private static final Log logger = LogFactory.getLog(DefaultIcbcClient.class);
    protected String appId;
    protected String privateKey;
    protected String signType = "RSA";
    protected String charset = "UTF-8";
    protected String format = "json";
    protected String icbcPulicKey;
    protected String encryptKey;
    protected String encryptType;
    protected String ca;
    protected String password;

    public DefaultIcbcClient(String appId, String signType, String privateKey, String charset, String format, String icbcPulicKey, String encryptType, String encryptKey, String ca, String password) {
        this.appId = appId;
        this.signType = signType;
        this.privateKey = privateKey;
        this.charset = charset;
        this.format = format;
        this.icbcPulicKey = icbcPulicKey;
        this.encryptType = encryptType;
        this.encryptKey = encryptKey;
        this.password = password;
        if (ca != null && !ca.equals("")) {
            Pattern p = Pattern.compile("\\s*|\t");
            Matcher m2 = p.matcher(ca);
            ca = m2.replaceAll("");
        }
        this.ca = ca;
    }

    public DefaultIcbcClient(String appId, String privateKey, String icbcPulicKey) {
        this(appId, "RSA", privateKey, "UTF-8", "json", icbcPulicKey, null, null, null, null);
    }

    public DefaultIcbcClient(String appId, String signType, String privateKey, String icbcPulicKey) {
        this(appId, signType, privateKey, "UTF-8", "json", icbcPulicKey, null, null, null, null);
    }

    public DefaultIcbcClient(String appId, String privateKey, String icbcPulicKey, String ca, String password) {
        this(appId, "CA", privateKey, "UTF-8", "json", icbcPulicKey, null, null, ca, password);
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> request) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        return this.execute(request, msgId);
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> request, String msgId) throws IcbcApiException {
        return this.execute(request, msgId, "");
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> request, String msgId, String appAuthToken) throws IcbcApiException {
        IcbcHashMap params = this.prepareParams(request, msgId, appAuthToken);
        String respStr = null;
        if (request.getMethod().equals("GET")) {
            respStr = WebUtils.doGet(request.getServiceUrl(), params, this.charset);
        } else if (request.getMethod().equals("POST")) {
            respStr = WebUtils.doPost(request.getServiceUrl(), params, this.charset);
        } else {
            logger.error((Object)("only support GET or POST, method: " + request.getMethod()));
            throw new IcbcApiException("only support GET or POST, method: " + request.getMethod());
        }
        T response = this.parse(request, respStr);
        if (response == null) {
            logger.error((Object)"response is null.");
            throw new IcbcApiException("response is null.");
        }
        return response;
    }

    @Override
    public <T extends IcbcResponse> void execute(IcbcRequest<T> request, WebUtils.IcbcApiFutureCallback<T> callback) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        this.execute(request, msgId, callback);
    }

    @Override
    public <T extends IcbcResponse> void execute(IcbcRequest<T> request, String msgId, WebUtils.IcbcApiFutureCallback<T> callback) throws IcbcApiException {
        this.execute(request, msgId, null, callback);
    }

    @Override
    public <T extends IcbcResponse> void execute(final IcbcRequest<T> request, String msgId, String appAuthToken, final WebUtils.IcbcApiFutureCallback<T> callback) throws IcbcApiException {
        IcbcHashMap params = this.prepareParams(request, msgId, appAuthToken);
        WebUtils.IcbcApiFutureCallback<String> callbackWrapper = new WebUtils.IcbcApiFutureCallback<String>(){

            @Override
            public void completed(String result) {
                try {
                    callback.completed(DefaultIcbcClient.this.parse(request, result));
                }
                catch (IcbcApiException e) {
                    callback.failed(e);
                }
            }

            @Override
            public void failed(IcbcApiException ex) {
                callback.failed(ex);
            }
        };
        if (request.getMethod().equals("GET")) {
            WebUtils.doGet(request.getServiceUrl(), (Map<String, String>)params, this.charset, callbackWrapper);
        } else if (request.getMethod().equals("POST")) {
            WebUtils.doPost(request.getServiceUrl(), (Map<String, String>)params, this.charset, callbackWrapper);
        } else {
            logger.error((Object)("only support GET or POST, method: " + request.getMethod()));
            throw new IcbcApiException("only support GET or POST, method: " + request.getMethod());
        }
    }

    protected <T extends IcbcResponse> T parse(IcbcRequest<T> request, String respStr) throws IcbcApiException {
        return this.parseJsonWithIcbcSign(request, respStr);
    }

    private <T extends IcbcResponse> T parseJsonWithIcbcSign(IcbcRequest<T> request, String respStr) throws IcbcApiException {
        String respBizContentStr = null;
        String sign = null;
        try {
            int indexOfRootStart = respStr.indexOf("response_biz_content") + "response_biz_content".length() + 2;
            int indexOfRootEnd = respStr.lastIndexOf(",");
            int indexOfSignStart = respStr.lastIndexOf("sign") + "sign".length() + 3;
            int indexOfSignEnd = respStr.lastIndexOf("\"");
            respBizContentStr = respStr.substring(indexOfRootStart, indexOfRootEnd);
            sign = respStr.substring(indexOfSignStart, indexOfSignEnd);
        }
        catch (Exception e) {
            logger.error((Object)("response is not format json. respStr :\n" + respStr), (Throwable)e);
            throw new IcbcApiException("response is not format json. respStr :\n" + respStr, e);
        }
        boolean passed = IcbcSignature.verify(respBizContentStr, "RSA", this.icbcPulicKey, this.charset, sign);
        if (!passed) {
            logger.error((Object)"icbc sign verify not passed.");
            throw new IcbcApiException("icbc sign verify not passed.");
        }
        if (request.isNeedEncrypt()) {
            respBizContentStr = IcbcEncrypt.decryptContent(respBizContentStr.substring(1, respBizContentStr.length() - 1), this.encryptType, this.encryptKey, this.charset);
        }
        try {
            return (T)((IcbcResponse)JSON.parseObject(respBizContentStr, request.getResponseClass()));
        }
        catch (Exception e) {
            logger.error((Object)("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName()), (Throwable)e);
            throw new IcbcApiException("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), e);
        }
    }

    protected IcbcHashMap prepareParams(IcbcRequest<?> request, String msgId, String appAuthToken) throws IcbcApiException {
        String path;
        String bizContentStr = this.buildBizContentStr(request);
        try {
            path = new URL(request.getServiceUrl()).getPath();
        }
        catch (MalformedURLException e) {
            logger.error((Object)("url is not valid. url: " + request.getServiceUrl()), (Throwable)e);
            throw new IcbcApiException("url is not valid. url: " + request.getServiceUrl(), e);
        }
        IcbcHashMap params = new IcbcHashMap();
        Map<String, String> extraParams = request.getExtraParameters();
        if (extraParams != null) {
            params.putAll(extraParams);
        }
        params.put("app_id", this.appId);
        params.put("sign_type", this.signType);
        params.put("charset", this.charset);
        params.put("format", this.format);
        params.put("ca", this.ca);
        params.put("app_auth_token", appAuthToken);
        params.put("msg_id", msgId);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        params.put("timestamp", df.format(new Date(timestamp)));
        if (request.isNeedEncrypt()) {
            if (!StringUtils.areNotEmpty(this.encryptType, this.encryptKey)) {
                logger.error((Object)"request need be encrypted, encrypt type and encrypt key can not be null.");
                throw new IcbcApiException("request need be encrypted, encrypt type and encrypt key can not be null.");
            }
            if (bizContentStr != null) {
                params.put("encrypt_type", this.encryptType);
                params.put("biz_content", IcbcEncrypt.encryptContent(bizContentStr, this.encryptType, this.encryptKey, this.charset));
            }
        } else {
            params.put("biz_content", bizContentStr);
        }
        String strToSign = WebUtils.buildOrderedSignStr(path, params);
        String signedStr = IcbcSignature.sign(strToSign, this.signType, this.privateKey, this.charset, this.password);
        params.put("sign", signedStr);
        return params;
    }

    protected String buildBizContentStr(IcbcRequest<?> request) throws IcbcApiException {
        if (request.getBizContent() == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return JSON.toJSONString(request.getBizContent());
        }
        logger.error((Object)("only support json format, current format is not supported. format: " + this.format));
        throw new IcbcApiException("only support json format, current format is not supported. format: " + this.format);
    }
}

