/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api;

import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcRequest;
import com.icbc.api.utils.HttpRequestParamsUtils;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.WebUtils;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiIcbcClient
extends DefaultIcbcClient {
    public UiIcbcClient(String appId, String privateKey, String charset, String ca, String password) {
        super(appId, "CA", privateKey, charset, "json", null, null, null, ca, password);
    }

    public UiIcbcClient(String appId, String privateKey, String charset) {
        super(appId, "RSA", privateKey, charset, "json", null, null, null, null, null);
    }

    public UiIcbcClient(String appId, String signType, String privateKey, String charset) {
        super(appId, signType, privateKey, charset, "json", null, null, null, null, null);
    }

    public UiIcbcClient(String appId, String signType, String privateKey, String charset, String encryptType, String encryptKey) {
        super(appId, signType, privateKey, charset, "json", null, encryptType, encryptKey, null, null);
    }

    public UiIcbcClient(String appId, String signType, String privateKey, String charset, String encryptType, String encryptKey, String ca, String password) {
        super(appId, signType, privateKey, charset, "json", null, encryptType, encryptKey, ca, password);
    }

    public String buildPostForm(IcbcRequest<?> request) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        return this.buildPostForm(request, msgId, null);
    }

    public String buildPostForm(IcbcRequest<?> request, String msgId) throws IcbcApiException {
        return this.buildPostForm(request, msgId, null);
    }

    public String buildPostForm(IcbcRequest<?> request, String msgId, String appAuthToken) throws IcbcApiException {
        IcbcHashMap params = this.prepareParams(request, msgId, appAuthToken);
        IcbcHashMap urlQueryParams = this.buildUrlQueryParams(params);
        String url = WebUtils.buildGetUrl(request.getServiceUrl(), urlQueryParams, this.charset);
        return WebUtils.buildForm(url, this.buildBodyParams(params));
    }

    protected IcbcHashMap buildBodyParams(IcbcHashMap params) {
        IcbcHashMap urlQueryParams = new IcbcHashMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (HttpRequestParamsUtils.isApiParam(key)) continue;
            urlQueryParams.put(key, (String)entry.getValue());
        }
        return urlQueryParams;
    }

    protected IcbcHashMap buildUrlQueryParams(IcbcHashMap params) {
        IcbcHashMap urlQueryParams = new IcbcHashMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (!HttpRequestParamsUtils.isApiParam(key)) continue;
            urlQueryParams.put(key, (String)entry.getValue());
        }
        return urlQueryParams;
    }
}

