/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.crypt;

import com.icbc.api.crypt.AES;
import com.icbc.api.internal.util.codec.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;

public class RSA {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final int LINE_SIZE = 65;
    private static final String NEW_LINE_STR = System.getProperty("line.separator");
    private static final byte[] NEW_LINE_BYTES = NEW_LINE_STR.getBytes();
    private static final byte[] START_PUBLIC_KEY_BYTES = "##############start public key##############".getBytes();
    private static final byte[] END_PUBLIC_KEY_BYTES = "##############end public key##############".getBytes();
    private static final byte[] START_PRIVATE_KEY_BYTES = "##############start private key##############".getBytes();
    private static final byte[] END_PRIVATE_KEY_BYTES = "##############end private key##############".getBytes();
    private static final String GENERATR_ALG = "key generate algorithm: ";

    public static KeyPair generateKeyPair() throws Exception {
        return RSA.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keysize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keysize, new SecureRandom(UUID.randomUUID().toString().getBytes()));
        return keyPairGenerator.generateKeyPair();
    }

    public static String sign(byte[] data, byte[] privateKey, String password, String algorithm) throws Exception {
        return RSA.sign(data, AES.aesDecrypt(privateKey, password), algorithm);
    }

    public static String sign(byte[] data, byte[] privateKey, String algorithm) throws Exception {
        PKCS8EncodedKeySpec pksc = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyfactory = KeyFactory.getInstance("RSA");
        PrivateKey pk = keyfactory.generatePrivate(pksc);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(pk);
        signature.update(data);
        return Base64.encodeBase64String(signature.sign());
    }

    public static boolean verify(byte[] data, byte[] publicKey, String sign, String algorithm) throws Exception {
        X509EncodedKeySpec xksc = new X509EncodedKeySpec(publicKey);
        KeyFactory keyfactory = KeyFactory.getInstance("RSA");
        PublicKey pk = keyfactory.generatePublic(xksc);
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(pk);
        signature.update(data);
        return signature.verify(Base64.decodeBase64(sign));
    }

    public static void generateRsa(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream) throws Exception {
        RSA.generateRsa(priKeyOutputStream, pubKeyOutputStream, null);
    }

    public static void generateRsa(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, String password) throws Exception {
        RSA.saveKeys(priKeyOutputStream, pubKeyOutputStream, RSA.generateKeyPair(), password);
    }

    public static void genRsaWithoutNewline(int keysize, OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream) throws Exception {
        RSA.genRsaWithoutNewline(keysize, priKeyOutputStream, pubKeyOutputStream, null);
    }

    public static void genRsaWithoutNewline(int keysize, OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, String password) throws Exception {
        KeyPair kp = RSA.generateKeyPair(keysize);
        RSA.savePrivateKeyWithoutNewline(priKeyOutputStream, kp.getPrivate().getEncoded(), password);
        RSA.savePublicKeyWithoutNewline(pubKeyOutputStream, kp.getPublic().getEncoded());
    }

    public static String loadPublicKeyFromStream(String filePath) throws Exception {
        return RSA.loadApiKeyFromStream(new FileInputStream(filePath), KeyType.PUBLIC_KEY);
    }

    protected static String loadApiKeyFromStream(InputStream in, KeyType keyType) throws Exception {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader rb = new BufferedReader(isr);
        StringBuffer privateKey = new StringBuffer();
        String line = null;
        boolean firstLine = true;
        boolean containsDesc = false;
        boolean start = false;
        while ((line = rb.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(GENERATR_ALG)) {
                    containsDesc = true;
                }
                firstLine = false;
            }
            if (containsDesc && !start) {
                if (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(START_PRIVATE_KEY_BYTES))) {
                    start = true;
                    continue;
                }
                if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !line.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                start = true;
                continue;
            }
            if (start && (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(END_PRIVATE_KEY_BYTES)) || keyType.equals((Object)KeyType.PUBLIC_KEY) && line.equals(new String(END_PUBLIC_KEY_BYTES)))) break;
            privateKey.append(line);
        }
        return privateKey.toString().trim();
    }

    public static byte[] loadPublicKeyFromStream(InputStream in) throws Exception {
        return RSA.loadKeyFromStream(in, KeyType.PUBLIC_KEY);
    }

    public static byte[] loadPrivateKeyFromStream(InputStream in, String password) throws Exception {
        return AES.aesDecrypt(RSA.loadKeyFromStream(in, KeyType.PRIVATE_KEY), password);
    }

    public static byte[] loadPrivateKeyFromStream(InputStream in) throws Exception {
        return RSA.loadKeyFromStream(in, KeyType.PRIVATE_KEY);
    }

    protected static void saveKeys(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, KeyPair kp) throws Exception {
        RSA.saveKeys(priKeyOutputStream, pubKeyOutputStream, kp, null);
    }

    protected static void saveKeys(OutputStream priKeyOutputStream, OutputStream pubKeyOutputStream, KeyPair kp, String password) throws Exception {
        RSA.savePrivateKey(priKeyOutputStream, kp.getPrivate().getEncoded(), password);
        RSA.savePublicKey(pubKeyOutputStream, kp.getPublic().getEncoded());
    }

    protected static void savePublicKey(OutputStream pubKeyOutputStream, byte[] pubKeyBytes) throws Exception {
        try {
            pubKeyOutputStream.write(RSA.getTitle().getBytes(CHARSET_UTF8));
            pubKeyOutputStream.write(NEW_LINE_BYTES);
            pubKeyOutputStream.write(START_PUBLIC_KEY_BYTES);
            pubKeyOutputStream.write(NEW_LINE_BYTES);
            RSA.saveBase64KeyToStream(Base64.encodeBase64(pubKeyBytes), pubKeyOutputStream);
            pubKeyOutputStream.write(END_PUBLIC_KEY_BYTES);
        }
        finally {
            pubKeyOutputStream.flush();
            pubKeyOutputStream.close();
        }
    }

    protected static void savePrivateKey(OutputStream priKeyOutputStream, byte[] priKeyBytes, String password) throws Exception {
        try {
            if (password != null) {
                priKeyBytes = AES.aesEncrypt(priKeyBytes, password);
            }
            priKeyOutputStream.write(RSA.getTitle().getBytes(CHARSET_UTF8));
            priKeyOutputStream.write(NEW_LINE_BYTES);
            priKeyOutputStream.write(START_PRIVATE_KEY_BYTES);
            priKeyOutputStream.write(NEW_LINE_BYTES);
            RSA.saveBase64KeyToStream(Base64.encodeBase64(priKeyBytes), priKeyOutputStream);
            priKeyOutputStream.write(END_PRIVATE_KEY_BYTES);
        }
        finally {
            priKeyOutputStream.flush();
            priKeyOutputStream.close();
        }
    }

    protected static void savePublicKeyWithoutNewline(OutputStream pubKeyOutputStream, byte[] pubKeyBytes) throws Exception {
        try {
            pubKeyOutputStream.write(Base64.encodeBase64(pubKeyBytes));
        }
        finally {
            pubKeyOutputStream.flush();
            pubKeyOutputStream.close();
        }
    }

    protected static void savePrivateKeyWithoutNewline(OutputStream priKeyOutputStream, byte[] priKeyBytes, String password) throws Exception {
        try {
            if (password != null) {
                priKeyBytes = AES.aesEncrypt(priKeyBytes, password);
            }
            priKeyOutputStream.write(Base64.encodeBase64(priKeyBytes));
        }
        finally {
            priKeyOutputStream.flush();
            priKeyOutputStream.close();
        }
    }

    protected static byte[] loadKeyFromStream(InputStream in, KeyType keyType) throws Exception {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader rb = new BufferedReader(isr);
        StringBuffer privateKey = new StringBuffer();
        String line = null;
        boolean firstLine = true;
        boolean containsDesc = false;
        boolean start = false;
        while ((line = rb.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(GENERATR_ALG)) {
                    containsDesc = true;
                }
                firstLine = false;
            }
            if (containsDesc && !start) {
                if (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(START_PRIVATE_KEY_BYTES))) {
                    start = true;
                    continue;
                }
                if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !line.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                start = true;
                continue;
            }
            if (start && (keyType.equals((Object)KeyType.PRIVATE_KEY) && line.equals(new String(END_PRIVATE_KEY_BYTES)) || keyType.equals((Object)KeyType.PUBLIC_KEY) && line.equals(new String(END_PUBLIC_KEY_BYTES)))) break;
            privateKey.append(line);
        }
        return Base64.decodeBase64(privateKey.toString());
    }

    protected static void saveBase64KeyToStream(byte[] base64Bytes, OutputStream out) throws IOException {
        int len = 0;
        for (int start = 0; start < base64Bytes.length; start += len) {
            len = Math.min(65, base64Bytes.length - start);
            out.write(base64Bytes, start, len);
            out.write(NEW_LINE_BYTES);
        }
    }

    protected static String getTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(GENERATR_ALG);
        sb.append("RSA");
        sb.append(NEW_LINE_STR);
        sb.append("key size: ");
        sb.append(1024);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyType {
        PUBLIC_KEY("public key"),
        PRIVATE_KEY("private key");

        String type;

        private KeyType(String type) {
            this.type = type;
        }
    }
}

