/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.client.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

