/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.icbc.api.internal.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    public String getAttributeName() {
        return "version";
    }
}

