/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.reactor.ssl;

import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBufferManagementStrategy;
import com.icbc.api.internal.apache.http.util.Args;
import java.nio.ByteBuffer;

public class PermanentSSLBufferManagementStrategy
implements SSLBufferManagementStrategy {
    public SSLBuffer constructBuffer(int size) {
        return new InternalBuffer(size);
    }

    private static final class InternalBuffer
    implements SSLBuffer {
        private final ByteBuffer buffer;

        public InternalBuffer(int size) {
            Args.positive(size, "size");
            this.buffer = ByteBuffer.allocate(size);
        }

        public ByteBuffer acquire() {
            return this.buffer;
        }

        public void release() {
        }

        public boolean isAcquired() {
            return true;
        }

        public boolean hasData() {
            return this.buffer.position() > 0;
        }
    }
}

