/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            BigDecimal val = (BigDecimal)object;
            String outText = out.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) ? val.toPlainString() : val.toString();
            out.write(outText);
            if (out.isEnabled(SerializerFeature.WriteClassName) && fieldType != BigDecimal.class && val.scale() == 0) {
                out.write(46);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return BigDecimalCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            BigDecimal decimalValue = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)decimalValue;
        }
        if (lexer.token() == 3) {
            BigDecimal val = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)val;
        }
        Object value = parser.parse();
        return (T)(value == null ? null : TypeUtils.castToBigDecimal(value));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

