/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.IcbcApiException;
import com.icbc.api.internal.apache.http.client.HttpClient;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.config.SocketConfig;
import com.icbc.api.internal.apache.http.impl.client.CloseableHttpClient;
import com.icbc.api.internal.apache.http.impl.client.HttpClients;
import com.icbc.api.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.icbc.api.internal.apache.http.impl.nio.client.HttpAsyncClients;
import com.icbc.api.internal.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import com.icbc.api.internal.apache.http.nio.client.util.HttpAsyncClientUtils;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientUtils {
    public static int MAX_HTTP_CONNETIONS = 200;
    private static final Log logger = LogFactory.getLog(HttpClientUtils.class);
    private static CloseableHttpClient syncHttpClient = null;
    private static CloseableHttpAsyncClient asyncHttpClient = null;

    private static void initSyncHttpClient() throws IcbcApiException {
        logger.info((Object)("[connection-timeout]=8000 [socket-timeout]=30000 [max-per-route]=" + MAX_HTTP_CONNETIONS + " [max-total]=" + MAX_HTTP_CONNETIONS + " config sync http client."));
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(8000).setSocketTimeout(30000).build();
            SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(true).setTcpNoDelay(true).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setDefaultMaxPerRoute(MAX_HTTP_CONNETIONS);
            cm.setMaxTotal(MAX_HTTP_CONNETIONS);
            cm.setDefaultSocketConfig(socketConfig);
            syncHttpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager(cm).build();
        }
        catch (Exception e) {
            throw new IcbcApiException("build sync http client exception.", e);
        }
        logger.info((Object)"add shut down hook to release http connection pool and close sync http client.");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                com.icbc.api.internal.apache.http.client.utils.HttpClientUtils.closeQuietly(syncHttpClient);
            }
        });
    }

    private static void initAsyncHttpClient() throws IcbcApiException {
        logger.info((Object)("[connection-timeout]=8000 [socket-timeout]=30000 [max-per-route]=" + MAX_HTTP_CONNETIONS + " [max-total]=" + MAX_HTTP_CONNETIONS + " config async http client."));
        try {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(3000).setConnectTimeout(30000).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
            PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioReactor);
            connManager.setDefaultMaxPerRoute(MAX_HTTP_CONNETIONS);
            connManager.setMaxTotal(MAX_HTTP_CONNETIONS);
            asyncHttpClient = HttpAsyncClients.custom().setConnectionManager(connManager).setDefaultRequestConfig(requestConfig).build();
            asyncHttpClient.start();
        }
        catch (IOReactorException e) {
            throw new IcbcApiException("create connecting io reactor exception.", e);
        }
        catch (Exception e) {
            throw new IcbcApiException("build async http client exception.", e);
        }
        logger.info((Object)"add shut down hook to release http connection pool and close async http client.");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                HttpAsyncClientUtils.closeQuietly(asyncHttpClient);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpAsyncClient getAsyncHttpClient() throws IcbcApiException {
        if (asyncHttpClient != null) {
            return asyncHttpClient;
        }
        Class<HttpClientUtils> clazz = HttpClientUtils.class;
        synchronized (HttpClientUtils.class) {
            if (asyncHttpClient == null) {
                HttpClientUtils.initAsyncHttpClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return asyncHttpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getSyncHttpClient() throws IcbcApiException {
        if (syncHttpClient != null) {
            return syncHttpClient;
        }
        Class<HttpClientUtils> clazz = HttpClientUtils.class;
        synchronized (HttpClientUtils.class) {
            if (syncHttpClient == null) {
                HttpClientUtils.initSyncHttpClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return syncHttpClient;
        }
    }
}

