/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.weixin.api;

import com.jiamai.weixin.api.API;
import com.jiamai.weixin.api.BaseAPI;
import com.jiamai.weixin.bean.qrcode.QrcodeTicket;
import com.jiamai.weixin.bean.qrcode.Wxaqrcode;
import com.jiamai.weixin.client.LocalHttpClient;
import com.jiamai.weixin.util.JsonUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrcodeAPI
extends BaseAPI {
    private static Logger logger = LoggerFactory.getLogger(QrcodeAPI.class);

    private static QrcodeTicket qrcodeCreate(String access_token, String qrcodeJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/qrcode/create").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(qrcodeJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, QrcodeTicket.class);
    }

    public static QrcodeTicket qrcodeCreateTemp(String access_token, int expire_seconds, long scene_id) {
        String json = String.format("{\"expire_seconds\": %d, \"action_name\": \"QR_SCENE\", \"action_info\": {\"scene\": {\"scene_id\": %d}}}", expire_seconds, scene_id);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static QrcodeTicket qrcodeCreateTemp(String access_token, int expire_seconds, String scene_str) {
        String json = String.format("{\"expire_seconds\": %d, \"action_name\": \"QR_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"%s\"}}}", expire_seconds, scene_str);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static QrcodeTicket qrcodeCreateFinal(String access_token, int scene_id) {
        String json = String.format("{\"action_name\": \"QR_LIMIT_SCENE\", \"action_info\": {\"scene\": {\"scene_id\":%d}}}", scene_id);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static QrcodeTicket qrcodeCreateFinal(String access_token, String scene_str) {
        String json = String.format("{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"%s\"}}}", scene_str);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static BufferedImage showqrcode(String ticket) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://mp.weixin.qq.com/cgi-bin/showqrcode").addParameter("ticket", ticket).build();
        CloseableHttpResponse httpResponse = LocalHttpClient.execute(httpUriRequest);
        return QrcodeAPI.getImage(httpResponse);
    }

    public static BufferedImage wxaappCreatewxaqrcode(String access_token, Wxaqrcode wxaqrcode) {
        String json = JsonUtil.toJSONString(wxaqrcode);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        CloseableHttpResponse httpResponse = LocalHttpClient.execute(httpUriRequest);
        return QrcodeAPI.getImage(httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getImage(CloseableHttpResponse httpResponse) {
        try {
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status == 200) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                return bufferedImage;
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }
}

