/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.weixin.client;

import com.jiamai.weixin.bean.DynamicField;
import com.jiamai.weixin.bean.paymch.MchBase;
import com.jiamai.weixin.client.LocalResponseHandler;
import com.jiamai.weixin.util.SignatureUtil;
import com.jiamai.weixin.util.XMLConverUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(XmlResponseHandler.class);

    public static <T> ResponseHandler<T> createResponseHandler(Class<T> clazz) {
        return new XmlResponseHandlerImpl<T>(null, clazz, null, null);
    }

    public static <T> ResponseHandler<T> createResponseHandler(Class<T> clazz, String sign_type, String key) {
        return new XmlResponseHandlerImpl<T>(null, clazz, sign_type, key);
    }

    public static class XmlResponseHandlerImpl<T>
    extends LocalResponseHandler
    implements ResponseHandler<T> {
        private Class<T> clazz;
        private String sign_type;
        private String key;

        public XmlResponseHandlerImpl(String uriId, Class<T> clazz, String sign_type, String key) {
            this.uriId = uriId;
            this.clazz = clazz;
            this.sign_type = sign_type;
            this.key = key;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)entity);
                Header contentType = response.getEntity().getContentType();
                if (contentType != null && !contentType.toString().matches(".*[uU][tT][fF]-8$")) {
                    str = new String(str.getBytes("iso-8859-1"), "utf-8");
                }
                logger.info("URI[{}] elapsed time:{} ms RESPONSE DATA:{}", new Object[]{this.uriId, System.currentTimeMillis() - this.startTime, str});
                T t = XMLConverUtil.convertToObject(this.clazz, str);
                if (t instanceof DynamicField || t instanceof MchBase && this.key != null) {
                    Map<String, String> map = XMLConverUtil.convertToMap(str);
                    if (t instanceof DynamicField) {
                        DynamicField dynamicField = (DynamicField)t;
                        dynamicField.buildDynamicField(map);
                    }
                    if (t instanceof MchBase && this.key != null) {
                        MchBase mchBase = (MchBase)t;
                        mchBase.setSign_status(SignatureUtil.validateSign(map, this.sign_type, this.key));
                    }
                }
                return t;
            }
            throw new ClientProtocolException("Unexpected response status: " + status);
        }
    }
}

