/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.weixin.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapUtil {
    private static Logger logger = LoggerFactory.getLogger(MapUtil.class);

    public static Map<String, String> order(Map<String, String> map) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().toString().compareTo(o2.getKey());
            }
        });
        for (int i = 0; i < infoIds.size(); ++i) {
            Map.Entry item = (Map.Entry)infoIds.get(i);
            tempMap.put((String)item.getKey(), (String)item.getValue());
        }
        return tempMap;
    }

    public static Map<String, String> objectToMap(Object object, String ... ignore) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        for (Field f : MapUtil.getAllFields(object.getClass())) {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            boolean ig = false;
            if (ignore != null && ignore.length > 0) {
                for (String i : ignore) {
                    if (!i.equals(f.getName())) continue;
                    ig = true;
                    break;
                }
            }
            if (ig) continue;
            Object o = null;
            try {
                o = f.get(object);
            }
            catch (IllegalArgumentException e) {
                logger.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("", (Throwable)e);
            }
            tempMap.put(f.getName(), o == null ? "" : o.toString());
        }
        return tempMap;
    }

    public static String mapJoin(Map<String, String> map, boolean keyLower, boolean valueUrlencode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : map.keySet()) {
            if (map.get(key) == null || "".equals(map.get(key))) continue;
            try {
                String temp = key.endsWith("_") && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
                stringBuilder.append(keyLower ? temp.toLowerCase() : temp).append("=").append(valueUrlencode ? URLEncoder.encode(map.get(key), "utf-8").replace("+", "%20") : map.get(key)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        if (!clazz.equals(Object.class)) {
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
            List<Field> fields2 = MapUtil.getAllFields(clazz.getSuperclass());
            if (fields2 != null) {
                fields.addAll(fields2);
            }
            return fields;
        }
        return null;
    }
}

