package com.jiamai.weixin.bean.message.massmessage;

import com.jiamai.weixin.bean.message.Uploadvideo;
import com.jiamai.weixin.bean.message.preview.Preview;
import com.jiamai.weixin.bean.message.preview.VideoPreview;

/**
 * 仅适用于对 openid 发送接口
 *
 * @author hong
 */
public class MassVideoMessage extends MassMessage {

    private static final long serialVersionUID = 8081012811169432063L;

    private Uploadvideo mpvideo;

    public MassVideoMessage(Uploadvideo uploadvideo) {
        super();
        mpvideo = uploadvideo;
        super.msgtype = "mpvideo";
    }

    public Uploadvideo getMpvideo() {
        return mpvideo;
    }

    public void setMpvideo(Uploadvideo mpvideo) {
        this.mpvideo = mpvideo;
    }

    @Override
    public Preview convert() {
        //转为 Preview，官方未说明该类型
        Preview preview = new VideoPreview(mpvideo);
        if (this.getTouser() != null && this.getTouser().size() > 0) {
            preview.setTouser(this.getTouser().iterator().next());
        }
        return preview;
    }
}
