/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.weixin.client;

import com.jiamai.weixin.bean.media.MediaGetResult;
import com.jiamai.weixin.client.LocalResponseHandler;
import com.jiamai.weixin.util.JsonUtil;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesOrJsonResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(BytesOrJsonResponseHandler.class);

    public static <T extends MediaGetResult> ResponseHandler<T> createResponseHandler(Class<T> clazz) {
        return new BytesOrJsonResponseHandlerImpl<T>(null, clazz);
    }

    public static class BytesOrJsonResponseHandlerImpl<T extends MediaGetResult>
    extends LocalResponseHandler
    implements ResponseHandler<T> {
        private Class<T> clazz;

        public BytesOrJsonResponseHandlerImpl(String uriId, Class<T> clazz) {
            this.uriId = uriId;
            this.clazz = clazz;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                String contentTypeStr;
                ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
                String string = contentTypeStr = contentType == null ? null : contentType.getMimeType();
                if (contentType != null && (ContentType.TEXT_PLAIN.getMimeType().equalsIgnoreCase(contentTypeStr) || ContentType.APPLICATION_JSON.getMimeType().equalsIgnoreCase(contentTypeStr))) {
                    HttpEntity entity = response.getEntity();
                    String str = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                    logger.info("URI[{}] elapsed time:{} ms RESPONSE DATA:{}", new Object[]{this.uriId, System.currentTimeMillis() - this.startTime, str});
                    return (T)((MediaGetResult)JsonUtil.parseObject(str, this.clazz));
                }
                try {
                    MediaGetResult t;
                    MediaGetResult mediaGetResult = t = (MediaGetResult)this.clazz.newInstance();
                    Header contentDisposition = response.getFirstHeader("Content-disposition");
                    if (contentDisposition != null) {
                        String filename = contentDisposition.getValue().replaceAll(".*filename=\"(.*)\".*", "$1");
                        mediaGetResult.setFilename(filename);
                    }
                    mediaGetResult.setContentType(contentTypeStr);
                    mediaGetResult.setBytes(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                    logger.info("URI[{}]ContentType:{} elapsed time:{} ms RESPONSE DATA:{}", new Object[]{this.uriId, contentTypeStr, System.currentTimeMillis() - this.startTime, ""});
                    return (T)t;
                }
                catch (InstantiationException e) {
                    logger.error("", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error("", (Throwable)e);
                }
            } else {
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
            return null;
        }
    }
}

