/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.weixin.util;

import com.jiamai.weixin.util.JsonUtil;
import com.jiamai.weixin.util.MapUtil;
import com.jiamai.weixin.util.PayUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class JsUtil {
    public static final String[] ALL_JS_API_LIST = new String[]{"checkJsApi", "updateAppMessageShareData", "updateTimelineShareData", "onMenuShareTimeline", "onMenuShareAppMessage", "onMenuShareQQ", "onMenuShareWeibo", "onMenuShareQZone", "chooseImage", "previewImage", "uploadImage", "downloadImage", "startRecord", "stopRecord", "onVoiceRecordEnd", "playVoice", "pauseVoice", "stopVoice", "onVoicePlayEnd", "uploadVoice", "downloadVoice", "translateVoice", "getNetworkType", "openLocation", "getLocation", "startSearchBeacons", "stopSearchBeacons", "onSearchBeacons", "hideOptionMenu", "showOptionMenu", "closeWindow", "hideMenuItems", "showMenuItems", "hideAllNonBaseMenuItem", "showAllNonBaseMenuItem", "scanQRCode", "openProductSpecificView", "chooseCard", "addCard", "openCard", "chooseWXPay", "openAddress"};

    public static String generateConfigSignature(String noncestr, String jsapi_ticket, String timestamp, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("noncestr", noncestr);
        map.put("jsapi_ticket", jsapi_ticket);
        map.put("timestamp", timestamp);
        map.put("url", url);
        Map<String, String> tmap = MapUtil.order(map);
        String str = MapUtil.mapJoin(tmap, true, false);
        return DigestUtils.shaHex((String)str);
    }

    public static String generateConfigJson(String jsapi_ticket, boolean debug, String appId, String url, String ... jsApiList) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString();
        String signature = JsUtil.generateConfigSignature(nonceStr, jsapi_ticket, timestamp + "", url);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("debug", debug);
        map.put("appId", appId);
        map.put("timestamp", timestamp);
        map.put("nonceStr", nonceStr);
        map.put("signature", signature);
        map.put("jsApiList", jsApiList == null ? ALL_JS_API_LIST : jsApiList);
        return JsonUtil.toJSONString(map);
    }

    public static String generateChooseWXPayJson(String prepay_id, String appId, String key) {
        String json = PayUtil.generateMchPayJsRequestJson(prepay_id, appId, key);
        json = json.replaceAll("\"timeStamp\"", "\"timestamp\"").replaceAll(",?\"appId\":\"[^\"]*\",?", "");
        return json;
    }
}

