package com.jiamai.winxin.api;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import com.jiamai.winxin.bean.token.Token;
import com.jiamai.winxin.client.LocalHttpClient;

/**
 * ACCESS_TOKEN API
 * @author hong
 *
 */
public class TokenAPI extends BaseAPI {

	/**
	 * 获取access_token
	 * @param appid appid
	 * @param secret secret
	 * @return Token
	 */
	public static Token token(String appid,String secret){
		HttpUriRequest httpUriRequest = RequestBuilder.get()
                                                      .setUri(BASE_URI + "/cgi-bin/token")
                                                      .addParameter("grant_type","client_credential")
                                                      .addParameter("appid", appid)
                                                      .addParameter("secret", secret)
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,Token.class);
	}

}
