package com.maila.biz.center.api.dto;

import java.io.Serializable;

/**
 * 功能描述:优惠券商品在线总数和阈值设置信息
 *
 * @author sunchangji
 * @date 2017/3/17
 */
public class CouponGoodsThresholdDto implements Serializable {
	private static final long serialVersionUID = -6321993265401287392L;
	/**
	 * 在线优惠券总数
	 */
	private int totalCount;
	/**
	 * 预警阈值
	 */
	private int threshold;

	/**
	 * 商品失效数量
	 */
	private int disabledCount;

	public CouponGoodsThresholdDto(){
		// Do nothing because of X and Y.
	}

	/**
	 * 构造器
	 * @param totalCount
	 * @param threshold
	 */
	public CouponGoodsThresholdDto(int totalCount,int threshold,int disabledCount){
		this.totalCount = totalCount;
		this.threshold = threshold;
		this.disabledCount = disabledCount;
	}

	public int getTotalCount() {
		return totalCount;
	}

	public void setTotalCount(int totalCount) {
		this.totalCount = totalCount;
	}

	public int getThreshold() {
		return threshold;
	}

	public void setThreshold(int threshold) {
		this.threshold = threshold;
	}

	public int getDisabledCount() {
		return disabledCount;
	}

	public void setDisabledCount(int disabledCount) {
		this.disabledCount = disabledCount;
	}
}
