package com.maila.biz.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述:tab下商品或专场信息实体对象
 *
 * @author sunchangji
 * @date 2016/11/10
 */
public class TabGoodsSpecialDto implements Serializable{

	private static final long serialVersionUID = 3710283292269993509L;

	/**
	 * 关联id
	 */
	private Long relationId;
	/**
	 * 类型(1:URL,2:商品,3:专场)
	 */
	private Integer relationType;

	/**
	 * 商品title
	 */
	private String title;

	/**
	 * 商品标签
	 */
	private String tag;
	/**
	 * 商品图片
	 */
	private String imgUrl;
	/**
	 * relationType为1则为URL,为2则为淘宝itemId
	 */
	private String goodsContent;
	/**
	 * 商品原始价格
	 */
	private Integer originalPrice;
	/**
	 * 商品优惠价
	 */
	private Integer preferPrice;
	/**
	 * relationType为3(专场)时,该专场下已上架商品总数
	 */
	private Integer specialGoodsCount;
	/**
	 * 商品30天销量/专场下全部商品30天销量总和
	 */
	private Long saleCount;

	/**
	 * 商品个性化副标题
	 */
	private String subTitle;

	/**
	 * 商品图片角标
	 */
	private String cornerImgUrl;

	/**
	 * 商品虚拟库倒计时开关
	 */
	private Integer countDown;

	/**
	 * 商品排期时间开始
	 */
	private Date scheduleStartTime;

	/**
	 * 商品排期时间结束
	 */
	private Date scheduleEndTime;

	/**
	 * 已抢议案图标地址，专场才有
	 */
	private String fontImgUrl;

	/**平台标识(-1:其他 0:淘宝,1:天猫)**/
	private Integer platformType;

	/**商品类型(1:优惠价,2:优惠券,3:货到付款)**/
	private Integer goodsType;

	/**商品现价**/
	private Integer finalPrice;

	/**
	 * 淘宝商品id
	 */
	private Long itemId;

	/**
	 * 当前偏移量
	 */
	private Integer offset;

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Integer getRelationType() {
		return relationType;
	}

	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}

	public String getGoodsContent() {
		return goodsContent;
	}

	public void setGoodsContent(String goodsContent) {
		this.goodsContent = goodsContent;
	}

	public Integer getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(Integer originalPrice) {
		this.originalPrice = originalPrice;
	}

	public Integer getPreferPrice() {
		return preferPrice;
	}

	public void setPreferPrice(Integer preferPrice) {
		this.preferPrice = preferPrice;
	}

	public Integer getSpecialGoodsCount() {
		return specialGoodsCount;
	}

	public void setSpecialGoodsCount(Integer specialGoodsCount) {
		this.specialGoodsCount = specialGoodsCount;
	}

	public Long getSaleCount() {
		return saleCount;
	}

	public void setSaleCount(Long saleCount) {
		this.saleCount = saleCount;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getCornerImgUrl() {
		return cornerImgUrl;
	}

	public void setCornerImgUrl(String cornerImgUrl) {
		this.cornerImgUrl = cornerImgUrl;
	}

	public Integer getCountDown() {
		return countDown;
	}

	public void setCountDown(Integer countDown) {
		this.countDown = countDown;
	}

	public Date getScheduleStartTime() {
		return scheduleStartTime;
	}

	public void setScheduleStartTime(Date scheduleStartTime) {
		this.scheduleStartTime = scheduleStartTime;
	}

	public Date getScheduleEndTime() {
		return scheduleEndTime;
	}

	public void setScheduleEndTime(Date scheduleEndTime) {
		this.scheduleEndTime = scheduleEndTime;
	}

	public String getFontImgUrl() {
		return fontImgUrl;
	}

	public void setFontImgUrl(String fontImgUrl) {
		this.fontImgUrl = fontImgUrl;
	}

	public Integer getPlatformType() {
		return platformType;
	}

	public void setPlatformType(Integer platformType) {
		this.platformType = platformType;
	}

	public Integer getGoodsType() {
		return goodsType;
	}

	public void setGoodsType(Integer goodsType) {
		this.goodsType = goodsType;
	}

	public Integer getFinalPrice() {
		return finalPrice;
	}

	public void setFinalPrice(Integer finalPrice) {
		this.finalPrice = finalPrice;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		this.offset = offset;
	}
}
