package com.maila.biz.center.api.enums;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Author: zhanghuifeng
 * Date:   10:30 2017/4/17
 */
public enum GoodsIdOrItemIdTypeEnum {
	ITEM_ID(1, "淘宝itemId"),
	GOODS_ID(2, "麦啦商品ID");

	private int id;
	private String name;

	GoodsIdOrItemIdTypeEnum(final int id,final String name){
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	/**
	 * 存入map
	 * @return Map
	 */
	@JsonValue
	public Map<String, Object> transform2Map() {
		Map<String, Object> map = new HashMap<>();
		map.put("name", getName());
		map.put("id", getId());
		return map;
	}
}
