package com.maila.biz.center.api.enums;

/**
 * 功能描述:麦啦商品状态枚举定义
 * 1:待提交,2:待审核,3:审核不通过,4:审核通过,5:活动中,6:已失效,7:已结束
 * @author sunchangji
 * @date 2016/12/9
 */
public enum MailaGoodsStatusEnum {

	NOT_SUBMIT(1,"待提交"),
	AUDITING(2,"待审核"),
	AUDIT_NOT_PASS(3,"审核不通过"),
	AUDIT_PASSED(4,"审核通过"),
	ACTIVITY_IN(5,"活动中"),
	OFF_SALE(6,"已失效"),
	END(7,"已结束");

	private int status;
	private String statusDesc;

	MailaGoodsStatusEnum(int status,String statusDesc){
		this.status=status;
		this.statusDesc=statusDesc;
	}

	public int getStatus() {
		return status;
	}

	public String getStatusDesc() {
		return statusDesc;
	}
}
