package com.maila.biz.center.api.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 麦啦商品所属平台类型
 * <p>
 * ClassName:MailaPlatformTypeEnum
 * @Date 14:24 2017/01/11
 */
public enum MailaPlatformTypeEnum {

    OTHER(-1, "其他"), TAOBAO(0, "淘宝"), TIANMAO(1, "天猫");

    private int id;
    private String name;

    MailaPlatformTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<MailaPlatformTypeEnum> result = Collections2.filter(Arrays.asList(MailaPlatformTypeEnum.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

}
