package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 店铺主营商品类目
 * <p>
 * ClassName:CommodityType
 * Date     : 2016年12月05日 16:01:08
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum MailaShopCommodityType {

    CLOTHES(1, "女装男装"),
    SHOE_BAG(2, "鞋类箱包"),
    BABY_STUFF(3, "母婴用品"),
    SKIN_MAKEUP(4, "护肤彩妆"),
    DELICIOUS(5, " 汇吃美食"),
    JEWELLERY_ORNAMENTS(6, "珠宝配饰"),
    BUILDING_MATERIALS(7, "家装建材"),
    HOME_TEXTILES(8, "家居家纺"),
    MARKET(9, "百货市场"),
    CAR_STUFF(10, "汽车用品"),
    PHONE_DIGITAL(11, "手机数码"),
    HOUSE_OFFICE(12, "家电办公");


    private int id;
    private String name;

    MailaShopCommodityType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<MailaShopCommodityType> result = Collections2.filter(Arrays.asList(MailaShopCommodityType.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

	/**
     * 转换成map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
