package com.maila.biz.center.api.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 大淘客商品排序种类
 * Author: zhanghuifeng
 * Date:   15:22 2017/6/1
 */
public enum MailaThirdpartySortTypeEnum {
	DEFAULT(0,"id"),
	VOLUME(1,"volume"),
	COUPON_RECEIVE(2,"coupon_receive"),
	PREFER_PRICE(3,"prefer_price"),
	COMMISSION_RATE(4,"commission_rate");

	private int id;

	private String name;

	MailaThirdpartySortTypeEnum(int id, String name){
		this.id = id;
		this.name = name;
	}

	/**
	 * 根据id获取名称
	 *
	 * @param id id
	 * @return String
	 */
	public static String getNameById(final int id) {
		Collection<MailaThirdpartySortTypeEnum> result = Collections2.filter(Arrays.asList(MailaThirdpartySortTypeEnum.values()), gs -> gs.getId() == id);
		return result.isEmpty() ? DEFAULT.getName() : result.iterator().next().getName();
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}
}
