package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 麦啦商品来源类型
 * <p>
 * ClassName:RelationType
 * Date     : 2016年11月03日 17:31:40
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum RelationType {

    URL(1, "url"), GOODS(2, "商品"), SPECIAL(3, "专场"),FIXED_IMAGE(4,"死图");

    private int id;
    private String name;

    RelationType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<RelationType> result = Collections2.filter(Arrays.asList(RelationType.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

	/**
     * 转换成map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
