package com.maila.biz.center.api.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 第三方商品库商品状态
 * @Author zhanghuifeng
 * @Date 19:07 2017/3/7
 */
public enum ThirdpartyGoodsStatusEnum {

	NOT_PUSH(0,"待入库"),PUSHED(1,"已入库"),EXIST(2,"已存在");

	private int status;

	private String statusDesc;

	ThirdpartyGoodsStatusEnum(int status, String statusDesc){
		this.status = status;
		this.statusDesc = statusDesc;
	}

	public int getStatus() {
		return status;
	}

	public String getStatusDesc() {
		return statusDesc;
	}

	/**
	 * 根据status获取名称
	 *
	 * @param status
	 * @return
	 */
	public static String getNameById(final int status) {
		Collection<ThirdpartyGoodsStatusEnum> result = Collections2.filter(Arrays.asList(ThirdpartyGoodsStatusEnum.values()), gs -> gs.getStatus() == status);
		return result.isEmpty() ? "" : result.iterator().next().getStatusDesc();
	}
}
